/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public final class RoundedContainer {
    private final Dimension2D dim;
    private final double titleHeight;
    private final double attributeHeight;
    private final HColor borderColor;
    private final HColor backColor;
    private final HColor imgBackcolor;
    private final UStroke stroke;

    public RoundedContainer(Dimension2D dim, double titleHeight, double attributeHeight, HColor borderColor, HColor backColor, HColor imgBackcolor, UStroke stroke) {
        if (dim.getWidth() == 0.0) {
            throw new IllegalArgumentException();
        }
        this.dim = dim;
        this.imgBackcolor = imgBackcolor;
        this.titleHeight = titleHeight;
        this.borderColor = borderColor;
        this.backColor = backColor;
        this.attributeHeight = attributeHeight;
        this.stroke = stroke;
    }

    public void drawU(UGraphic ug, boolean shadowing) {
        ug = ug.apply(this.backColor.bg()).apply(this.borderColor);
        URectangle rect = new URectangle(this.dim.getWidth(), this.dim.getHeight()).rounded(25.0);
        if (shadowing) {
            rect.setDeltaShadow(3.0);
        }
        ug.apply(this.stroke).draw(rect);
        double yLine = this.titleHeight + this.attributeHeight;
        ug = ug.apply(this.imgBackcolor.bg());
        double thickness = this.stroke.getThickness();
        URectangle inner = new URectangle(this.dim.getWidth() - 4.0 * thickness, this.dim.getHeight() - this.titleHeight - 4.0 * thickness - this.attributeHeight).rounded(25.0);
        ug.apply(this.imgBackcolor).apply(new UTranslate(2.0 * thickness, yLine + 2.0 * thickness)).draw(inner);
        if (this.titleHeight > 0.0) {
            ug.apply(this.stroke).apply(UTranslate.dy(yLine)).draw(ULine.hline(this.dim.getWidth()));
        }
        if (this.attributeHeight > 0.0) {
            ug.apply(this.stroke).apply(UTranslate.dy(yLine - this.attributeHeight)).draw(ULine.hline(this.dim.getWidth()));
        }
    }
}

