/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.svek.DotStringFactory;
import znaishaded.net.sourceforge.plantuml.svek.Point2DFunction;
import znaishaded.net.sourceforge.plantuml.svek.PointListIterator;
import znaishaded.net.sourceforge.plantuml.svek.PointListIteratorImpl;

public class SvgResult {
    public static final String D_EQUALS = "d=\"";
    public static final String POINTS_EQUALS = "points=\"";
    private final String svg;
    private final Point2DFunction function;

    public SvgResult(String svg, Point2DFunction function) {
        this.svg = svg;
        this.function = function;
    }

    public PointListIterator getPointsWithThisColor(int lineColor) {
        return PointListIteratorImpl.create(this, lineColor);
    }

    public List<Point2D.Double> extractList(String searched) {
        int p2 = this.indexOf(searched, 0);
        if (p2 == -1) {
            return Collections.emptyList();
        }
        int p3 = this.indexOf("\"", p2 + searched.length());
        if (p3 == -1) {
            return Collections.emptyList();
        }
        return this.substring(p2 + searched.length(), p3).getPoints(" MC");
    }

    public int getIndexFromColor(int color) {
        String s2 = "stroke=\"" + StringUtils.goLowerCase(DotStringFactory.sharp000000(color)) + "\"";
        int idx = this.svg.indexOf(s2);
        if (idx != -1) {
            return idx;
        }
        s2 = ";stroke:" + StringUtils.goLowerCase(DotStringFactory.sharp000000(color)) + ";";
        idx = this.svg.indexOf(s2);
        if (idx != -1) {
            return idx;
        }
        s2 = "fill=\"" + StringUtils.goLowerCase(DotStringFactory.sharp000000(color)) + "\"";
        idx = this.svg.indexOf(s2);
        if (idx != -1) {
            return idx;
        }
        return -1;
    }

    public List<Point2D.Double> getPoints(String separator) {
        try {
            StringTokenizer st = new StringTokenizer(this.svg, separator);
            ArrayList<Point2D.Double> result = new ArrayList<Point2D.Double>();
            while (st.hasMoreTokens()) {
                result.add(this.getFirstPoint(st.nextToken()));
            }
            return result;
        }
        catch (NumberFormatException e) {
            return Collections.emptyList();
        }
    }

    public Point2D.Double getNextPoint() {
        return this.getFirstPoint(this.svg);
    }

    private Point2D.Double getFirstPoint(String tmp) {
        StringTokenizer st = new StringTokenizer(tmp, ",");
        double startX = Double.parseDouble(st.nextToken());
        double startY = Double.parseDouble(st.nextToken());
        return this.function.apply(new Point2D.Double(startX, startY));
    }

    public int indexOf(String s2, int pos) {
        return this.svg.indexOf(s2, pos);
    }

    public SvgResult substring(int pos) {
        return new SvgResult(this.svg.substring(pos), this.function);
    }

    public SvgResult substring(int start, int end) {
        return new SvgResult(this.svg.substring(start, end), this.function);
    }

    public final String getSvg() {
        return this.svg;
    }
}

