/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.expression;

import java.util.ArrayDeque;
import java.util.Deque;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.expression.Knowledge;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.expression.Token;
import znaishaded.net.sourceforge.plantuml.tim.expression.TokenIterator;
import znaishaded.net.sourceforge.plantuml.tim.expression.TokenStack;
import znaishaded.net.sourceforge.plantuml.tim.expression.TokenType;

public class ShuntingYard {
    private final TokenStack ouputQueue = new TokenStack();
    private final Deque<Token> operatorStack = new ArrayDeque<Token>();
    private static final boolean TRACE = false;

    private void traceMe() {
    }

    public ShuntingYard(TokenIterator it, Knowledge knowledge) throws EaterException, EaterExceptionLocated {
        Token token;
        while (it.hasMoreTokens()) {
            token = it.nextToken();
            this.traceMe();
            if (token.getTokenType() == TokenType.NUMBER || token.getTokenType() == TokenType.QUOTED_STRING) {
                this.ouputQueue.add(token);
                continue;
            }
            if (token.getTokenType() == TokenType.FUNCTION_NAME) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getTokenType() == TokenType.PLAIN_TEXT) {
                String name = token.getSurface();
                TValue variable = knowledge.getVariable(name);
                if (variable == null) {
                    this.ouputQueue.add(new Token("undefined", TokenType.QUOTED_STRING, null));
                    continue;
                }
                this.ouputQueue.add(variable.toToken());
                continue;
            }
            if (token.getTokenType() == TokenType.OPERATOR) {
                while ((this.thereIsAFunctionAtTheTopOfTheOperatorStack(token) || this.thereIsAnOperatorAtTheTopOfTheOperatorStackWithGreaterPrecedence(token) || this.theOperatorAtTheTopOfTheOperatorStackHasEqualPrecedenceAndIsLeftAssociative(token)) && this.theOperatorAtTheTopOfTheOperatorStackIsNotALeftParenthesis(token)) {
                    this.ouputQueue.add(this.operatorStack.removeFirst());
                }
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getTokenType() == TokenType.OPEN_PAREN_FUNC) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getTokenType() == TokenType.OPEN_PAREN_MATH) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getTokenType() == TokenType.CLOSE_PAREN_FUNC) {
                Token first = this.operatorStack.removeFirst();
                this.ouputQueue.add(first);
                continue;
            }
            if (token.getTokenType() == TokenType.CLOSE_PAREN_MATH) {
                while (this.operatorStack.peekFirst().getTokenType() != TokenType.OPEN_PAREN_MATH) {
                    this.ouputQueue.add(this.operatorStack.removeFirst());
                }
                if (this.operatorStack.peekFirst().getTokenType() != TokenType.OPEN_PAREN_MATH) continue;
                this.operatorStack.removeFirst();
                continue;
            }
            if (token.getTokenType() == TokenType.COMMA) {
                while (this.operatorStack.peekFirst() != null && this.operatorStack.peekFirst().getTokenType() != TokenType.OPEN_PAREN_FUNC) {
                    this.ouputQueue.add(this.operatorStack.removeFirst());
                }
                continue;
            }
            throw new UnsupportedOperationException(token.toString());
        }
        while (!this.operatorStack.isEmpty()) {
            token = this.operatorStack.removeFirst();
            this.ouputQueue.add(token);
        }
    }

    private boolean thereIsAFunctionAtTheTopOfTheOperatorStack(Token token) {
        Token top = this.operatorStack.peekFirst();
        return top != null && top.getTokenType() == TokenType.FUNCTION_NAME;
    }

    private boolean thereIsAnOperatorAtTheTopOfTheOperatorStackWithGreaterPrecedence(Token token) {
        Token top = this.operatorStack.peekFirst();
        return top != null && top.getTokenType() == TokenType.OPERATOR && top.getTokenOperator().getPrecedence() > token.getTokenOperator().getPrecedence();
    }

    private boolean theOperatorAtTheTopOfTheOperatorStackHasEqualPrecedenceAndIsLeftAssociative(Token token) {
        Token top = this.operatorStack.peekFirst();
        return top != null && top.getTokenType() == TokenType.OPERATOR && top.getTokenOperator().isLeftAssociativity() && top.getTokenOperator().getPrecedence() == token.getTokenOperator().getPrecedence();
    }

    private boolean theOperatorAtTheTopOfTheOperatorStackIsNotALeftParenthesis(Token token) {
        Token top = this.operatorStack.peekFirst();
        if (top != null && top.getTokenType() == TokenType.OPEN_PAREN_MATH) {
            return true;
        }
        return true;
    }

    public TokenStack getQueue() {
        return this.ouputQueue;
    }
}

