/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.http.protocol;

import java.io.IOException;
import znaishaded.org.apache.http.HttpException;
import znaishaded.org.apache.http.HttpRequest;
import znaishaded.org.apache.http.HttpRequestInterceptor;
import znaishaded.org.apache.http.annotation.Contract;
import znaishaded.org.apache.http.annotation.ThreadingBehavior;
import znaishaded.org.apache.http.params.HttpParams;
import znaishaded.org.apache.http.protocol.HttpContext;
import znaishaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s2 = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s2 = (String)params.getParameter("http.useragent");
            }
            if (s2 == null) {
                s2 = this.userAgent;
            }
            if (s2 != null) {
                request.addHeader("User-Agent", s2);
            }
        }
    }
}

