/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.fs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.testingisdocumenting.znai.fs.UnzipTask;
import znaishaded.org.apache.commons.io.FileUtils;

public class FsUtils {
    private FsUtils() {
    }

    public static void unzip(Path zip, Path dest) {
        UnzipTask unzipTask = new UnzipTask(zip, dest);
        unzipTask.execute();
    }

    public static void deleteDirectory(Path dest) {
        try {
            FileUtils.deleteDirectory(dest.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void moveDirectory(Path src, Path dest) {
        try {
            FileUtils.moveDirectory(src.toFile(), dest.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyDirectory(Path src, Path dest) {
        try {
            FileUtils.copyDirectory(src.toFile(), dest.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path createTempDir(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

