/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.preview;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.AuxiliaryFileListener;
import org.testingisdocumenting.znai.server.preview.FileChangeHandler;
import org.testingisdocumenting.znai.website.WebSite;

public class FileWatcher
implements AuxiliaryFileListener {
    private final WebSite.Configuration siteCfg;
    private final FileChangeHandler fileChangeHandler;
    private final WatchService watchService;
    private final Map<WatchKey, Path> pathByKey;

    public FileWatcher(WebSite.Configuration siteCfg, Stream<Path> auxiliaryFiles, FileChangeHandler fileChangeHandler) {
        this.siteCfg = siteCfg;
        this.fileChangeHandler = fileChangeHandler;
        this.watchService = this.createWatchService();
        this.pathByKey = new HashMap<WatchKey, Path>();
        Path absoluteRoot = siteCfg.getDocRootPath().toAbsolutePath();
        this.register(absoluteRoot);
        this.registerDirs(absoluteRoot);
        auxiliaryFiles.forEach(this::register);
    }

    public void start() {
        try {
            this.startWatchLoop();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void startWatchLoop() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    this.watchCycle();
                }
            }
            catch (RuntimeException e) {
                ConsoleOutputs.err(e.getClass() + ":" + e.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchCycle() throws InterruptedException {
        WatchKey key = this.watchService.take();
        try {
            Path path = this.pathByKey.get(key);
            if (path == null) {
                ConsoleOutputs.err("bad watch key: ", key);
                return;
            }
            key.pollEvents().forEach(e -> this.handleEvent(path, (WatchEvent<?>)e));
        }
        finally {
            boolean isValid = key.reset();
            if (!isValid) {
                this.pathByKey.remove(key);
            }
        }
    }

    private void handleEvent(Path parentPath, WatchEvent<?> watchEvent) {
        WatchEvent.Kind<?> kind = watchEvent.kind();
        if (kind == StandardWatchEventKinds.OVERFLOW) {
            return;
        }
        Path relativePath = (Path)watchEvent.context();
        Path path = parentPath.resolve(relativePath);
        ConsoleOutputs.out("watch event: ", kind, " context: ", path);
        if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            this.handleModify(path);
        }
    }

    private void handleModify(Path path) {
        String fileName = path.getFileName().toString();
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.register(path);
        } else if (fileName.equals("toc")) {
            this.fileChangeHandler.onTocChange(path);
        } else if (fileName.equals("meta.json")) {
            this.fileChangeHandler.onDocMetaChange(path);
        } else if (path.equals(this.siteCfg.getGlobalReferencesPath())) {
            this.fileChangeHandler.onGlobalDocReferencesChange(path);
        } else {
            this.fileChangeHandler.onChange(path);
        }
    }

    private void register(Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                path = path.getParent();
            }
            if (path.endsWith(".vertx")) {
                return;
            }
            if (this.pathByKey.containsValue(path)) {
                return;
            }
            WatchKey key = path.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
            this.pathByKey.put(key, path);
            ConsoleOutputs.out("watching: ", path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerDirs(Path rootPath) {
        try {
            Stream<Path> pathStream = Files.list(rootPath);
            pathStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(this::register);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private WatchService createWatchService() {
        WatchService watchService;
        try {
            watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return watchService;
    }

    @Override
    public void onAuxiliaryFile(AuxiliaryFile auxiliaryFile) {
        this.register(auxiliaryFile.getPath());
    }
}

