/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class Dimension2DDouble
extends Dimension2D {
    private final double width;
    private final double height;

    public Dimension2DDouble(double width, double height) {
        if (Double.isNaN(width) || Double.isNaN(height)) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
    }

    public String toString() {
        return "[" + this.width + "," + this.height + "]";
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public void setSize(double width, double height) {
        throw new UnsupportedOperationException();
    }

    public static Dimension2D delta(Dimension2D dim, double delta) {
        return Dimension2DDouble.delta(dim, delta, delta);
    }

    public Dimension2DDouble withWidth(double newWidth) {
        return new Dimension2DDouble(newWidth, this.height);
    }

    public static Dimension2D delta(Dimension2D dim, double deltaWidth, double deltaHeight) {
        if (deltaHeight == 0.0 && deltaWidth == 0.0) {
            return dim;
        }
        return new Dimension2DDouble(dim.getWidth() + deltaWidth, dim.getHeight() + deltaHeight);
    }

    public static Dimension2D mergeTB(Dimension2D top, Dimension2D bottom) {
        double width = Math.max(top.getWidth(), bottom.getWidth());
        double height = top.getHeight() + bottom.getHeight();
        return new Dimension2DDouble(width, height);
    }

    public static Dimension2D mergeTB(Dimension2D a, Dimension2D b, Dimension2D c) {
        double width = MathUtils.max(a.getWidth(), b.getWidth(), c.getWidth());
        double height = a.getHeight() + b.getHeight() + c.getHeight();
        return new Dimension2DDouble(width, height);
    }

    public static Dimension2D mergeLR(Dimension2D left, Dimension2D right) {
        double height = Math.max(left.getHeight(), right.getHeight());
        double width = left.getWidth() + right.getWidth();
        return new Dimension2DDouble(width, height);
    }

    public static Dimension2D mergeLayoutT12B3(Dimension2D top1, Dimension2D top2, Dimension2D bottom) {
        double width = MathUtils.max(top1.getWidth(), top2.getWidth(), bottom.getWidth());
        double height = top1.getHeight() + top2.getHeight() + bottom.getHeight();
        return new Dimension2DDouble(width, height);
    }

    public static Dimension2D max(Dimension2D dim1, Dimension2D dim2) {
        return Dimension2DDouble.atLeast(dim1, dim2.getWidth(), dim2.getHeight());
    }

    public static Dimension2D atLeast(Dimension2D dim, double minWidth, double minHeight) {
        double h2 = dim.getHeight();
        double w = dim.getWidth();
        if (w > minWidth && h2 > minHeight) {
            return dim;
        }
        if (h2 < minHeight) {
            h2 = minHeight;
        }
        if (w < minWidth) {
            w = minWidth;
        }
        return new Dimension2DDouble(w, h2);
    }
}

