/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class InstructionSpot
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final LinkRendering inlinkRendering;
    private final String spot;
    private final HColor color;

    @Override
    public boolean containsBreak() {
        return false;
    }

    public InstructionSpot(String spot, HColor color, LinkRendering inlinkRendering, Swimlane swimlane) {
        super(swimlane);
        this.spot = spot;
        this.inlinkRendering = inlinkRendering;
        this.color = color;
        if (inlinkRendering == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile result = factory.spot(this.getSwimlaneIn(), this.spot, this.color);
        result = this.eventuallyAddNote(factory, result, result.getSwimlaneIn());
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    @Override
    public void add(Instruction other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean kill() {
        this.killed = true;
        return true;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }
}

