/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.brotli;

import java.nio.ByteBuffer;
import znaishaded.net.sourceforge.plantuml.brotli.BrotliRuntimeException;

public final class Dictionary {
    private static volatile ByteBuffer data;

    public static void setData(ByteBuffer data) {
        if (!data.isDirect() || !data.isReadOnly()) {
            throw new BrotliRuntimeException("data must be a direct read-only byte buffer");
        }
        Dictionary.data = data;
    }

    public static ByteBuffer getData() {
        if (data != null) {
            return data;
        }
        if (!DataLoader.OK) {
            throw new BrotliRuntimeException("brotli dictionary is not set");
        }
        return data;
    }

    private static class DataLoader {
        static final boolean OK;

        private DataLoader() {
        }

        static {
            boolean ok = true;
            try {
                Class.forName(Dictionary.class.getPackage().getName() + ".DictionaryData");
            }
            catch (Throwable ex) {
                ok = false;
            }
            OK = ok;
        }
    }
}

