/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.flowdiagram;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.golem.Tile;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class ActivityBox
extends AbstractTextBlock {
    private static final int CORNER = 25;
    private static final int MARGIN = 10;
    private final Tile tile;
    private final String id;
    private final String label;
    private final TextBlock tb;

    public ActivityBox(Tile tile, String id, String label) {
        this.tile = tile;
        this.id = id;
        this.label = label;
        UFont font = UFont.serif(14);
        FontConfiguration fc = FontConfiguration.blackBlueTrue(font);
        this.tb = Display.create(label).create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    public Tile getTile() {
        return this.tile;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void drawU(UGraphic ug) {
        Dimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal).rounded(25.0);
        ug = ug.apply(HColorUtils.MY_RED);
        ug = ug.apply(HColorUtils.MY_YELLOW.bg());
        ug.apply(new UStroke(1.5)).draw(rect);
        this.tb.drawU(ug.apply(new UTranslate(10.0, 10.0)));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.tb.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dim, 20.0, 20.0);
    }
}

