/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Dijkstra {
    private final double[][] basic;
    private final double[] dist;
    private final int[] previous;
    private final Set<Integer> q = new HashSet<Integer>();
    private final int size;

    public Dijkstra(int size) {
        this.size = size;
        this.basic = new double[size][size];
        this.dist = new double[size];
        this.previous = new int[size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.basic[i][j] = i == j ? 0.0 : Double.MAX_VALUE;
            }
        }
    }

    public void addLink(int n1, int n2, double d) {
        if (n1 == n2) {
            throw new IllegalArgumentException();
        }
        this.basic[n1][n2] = d;
        this.basic[n2][n1] = d;
    }

    private void init() {
        for (int i = 0; i < this.size; ++i) {
            this.dist[i] = Double.MAX_VALUE;
            this.previous[i] = -1;
            this.q.add(i);
        }
        this.dist[0] = 0.0;
    }

    private void computePrevious() {
        this.init();
        while (this.q.size() > 0) {
            int u = this.smallest();
            if (this.dist[u] == Double.MAX_VALUE) {
                return;
            }
            this.q.remove(u);
            for (int v = 0; v < this.size; ++v) {
                double alt;
                if (this.basic[u][v] == Double.MAX_VALUE || !((alt = this.dist[u] + this.basic[u][v]) < this.dist[v])) continue;
                this.dist[v] = alt;
                this.previous[v] = u;
            }
        }
    }

    public List<Integer> getBestPath() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        this.computePrevious();
        int u = this.size - 1;
        while (this.previous[u] >= 0) {
            result.add(0, u);
            u = this.previous[u];
        }
        result.add(0, 0);
        return Collections.unmodifiableList(result);
    }

    private int smallest() {
        int result = -1;
        for (Integer i : this.q) {
            if (result != -1 && !(this.dist[i] < this.dist[result])) continue;
            result = i;
        }
        return result;
    }

    public final int getSize() {
        return this.size;
    }
}

