/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph2;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.graph2.Measurer;
import znaishaded.net.sourceforge.plantuml.graph2.SortedListImpl;

public class RectanglesCollection
implements Iterable<Rectangle2D.Double> {
    private final List<Rectangle2D.Double> areas = new ArrayList<Rectangle2D.Double>();
    private final SortedListImpl<Rectangle2D.Double> sortedX1 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double data) {
            return (int)data.x;
        }
    });
    private final SortedListImpl<Rectangle2D.Double> sortedX2 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double data) {
            return (int)(data.x + data.width);
        }
    });
    private final SortedListImpl<Rectangle2D.Double> sortedY1 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double data) {
            return (int)data.y;
        }
    });
    private final SortedListImpl<Rectangle2D.Double> sortedY2 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double data) {
            return (int)(data.y + data.height);
        }
    });
    private Rectangle2D.Double max = null;
    private static long TPS1;
    private static long TPS2;

    public RectanglesCollection() {
    }

    public RectanglesCollection(Rectangle2D.Double rect) {
        this();
        this.add(rect);
    }

    public double getSurf() {
        if (this.max == null) {
            return 0.0;
        }
        return this.max.getWidth() * this.max.getHeight();
    }

    public void add(Rectangle2D.Double rect) {
        this.areas.add(rect);
        this.max = this.max == null ? rect : (Rectangle2D.Double)this.max.createUnion(rect);
    }

    @Override
    public Iterator<Rectangle2D.Double> iterator() {
        return this.areas.iterator();
    }

    public boolean intersect(RectanglesCollection other) {
        if (this.size() > other.size()) {
            return RectanglesCollection.intersectSeveral(this, other);
        }
        return RectanglesCollection.intersectSeveral(other, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean intersectSeveral(RectanglesCollection large, RectanglesCollection compact) {
        assert (large.size() >= compact.size());
        long start = System.currentTimeMillis();
        try {
            for (Rectangle2D.Double r : compact) {
                if (!large.intersectSimple(r)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TPS2 += System.currentTimeMillis() - start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean intersectSimple(Rectangle2D.Double rect) {
        long start = System.currentTimeMillis();
        try {
            if (this.max == null || !this.max.intersects(rect)) {
                boolean bl = false;
                return bl;
            }
            for (Rectangle2D.Double r : this.areas) {
                if (!rect.intersects(r)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TPS1 += System.currentTimeMillis() - start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean intersectSimpleOld(Rectangle2D.Double rect) {
        long start = System.currentTimeMillis();
        try {
            List<Rectangle2D.Double> lY2;
            List<Rectangle2D.Double> lY1;
            List<Rectangle2D.Double> lX1;
            if (this.max == null || !this.max.intersects(rect)) {
                boolean bl = false;
                return bl;
            }
            List<Rectangle2D.Double> lmin = lX1 = this.sortedX1.lesserOrEquals((int)(rect.x + rect.width));
            if (lX1.size() == 0) {
                boolean bl = false;
                return bl;
            }
            List<Rectangle2D.Double> lX2 = this.sortedX2.biggerOrEquals((int)rect.x);
            if (lX2.size() == 0) {
                boolean bl = false;
                return bl;
            }
            if (lX2.size() < lmin.size()) {
                lmin = lX2;
            }
            if ((lY1 = this.sortedY1.lesserOrEquals((int)(rect.y + rect.height))).size() == 0) {
                boolean bl = false;
                return bl;
            }
            if (lY1.size() < lmin.size()) {
                lmin = lY1;
            }
            if ((lY2 = this.sortedY2.biggerOrEquals((int)rect.y)).size() == 0) {
                boolean bl = false;
                return bl;
            }
            if (lY2.size() < lmin.size()) {
                lmin = lY2;
            }
            for (Rectangle2D.Double r : lmin) {
                if (!rect.intersects(r)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TPS1 += System.currentTimeMillis() - start;
        }
    }

    public int size() {
        return this.areas.size();
    }

    public void addAll(RectanglesCollection other) {
        for (Rectangle2D.Double r : other.areas) {
            this.add(r);
        }
    }
}

