/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.SkinParameter;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEmpty;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;

class USymbolNode
extends USymbol {
    USymbolNode() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.NODE;
    }

    private void drawNode(UGraphic ug, double width, double height, boolean shadowing) {
        UPolygon shape = new UPolygon();
        shape.addPoint(0.0, 10.0);
        shape.addPoint(10.0, 0.0);
        shape.addPoint(width, 0.0);
        shape.addPoint(width, height - 10.0);
        shape.addPoint(width - 10.0, height);
        shape.addPoint(0.0, height);
        shape.addPoint(0.0, 10.0);
        if (shadowing) {
            shape.setDeltaShadow(2.0);
        }
        ug.draw(shape);
        ug.apply(new UTranslate(width - 10.0, 10.0)).draw(new ULine(10.0, -10.0));
        ug.apply(UTranslate.dy(10.0)).draw(ULine.hline(width - 10.0));
        ug.apply(new UTranslate(width - 10.0, 10.0)).draw(ULine.vline(height - 10.0));
        if (SkinParam.USE_STYLES()) {
            ug.apply(new UTranslate(0.0, height)).draw(new UEmpty(10.0, 10.0));
        }
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 25.0, 20.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolNode.this.drawNode(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolNode.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                MyUGraphicNode ug2 = new MyUGraphicNode(ug, dim.getWidth());
                tb.drawU(ug2.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolNode.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolNode.this.drawNode(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                ug = ug.apply(new UTranslate(-4.0, 11.0));
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereoY = 2.0;
                double posStereoX = stereoAlignment == HorizontalAlignment.RIGHT ? width - dimStereo.getWidth() - USymbolNode.this.getMargin().getX1() : (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, 2.0)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }

    @Override
    public int suppHeightBecauseOfShape() {
        return 5;
    }

    @Override
    public int suppWidthBecauseOfShape() {
        return 60;
    }

    class MyUGraphicNode
    extends AbstractUGraphicHorizontalLine {
        private final double endingX;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicNode(ug, this.endingX);
        }

        public MyUGraphicNode(UGraphic ug, double endingX) {
            super(ug);
            this.endingX = endingX;
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            ug = ug.apply(translate);
            this.drawHlineInternal(ug, line);
            if (line.isDouble()) {
                this.drawHlineInternal(ug.apply(UTranslate.dy(2.0)), line);
            }
            line.drawTitleInternal(ug, 0.0, this.endingX - 10.0, 0.0, true);
        }

        private void drawHlineInternal(UGraphic ug, UHorizontalLine line) {
            ug = ug.apply(line.getStroke()).apply(new HColorNone().bg());
            ug.draw(ULine.hline(this.endingX - 10.0));
            ug.apply(UTranslate.dx(this.endingX - 10.0)).draw(new ULine(10.0, -10.0));
        }
    }
}

