/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.hector.PinLink;
import znaishaded.net.sourceforge.plantuml.hector.PinLinksContinuousSet;
import znaishaded.net.sourceforge.plantuml.hector.Skeleton;

public class SkeletonBuilder {
    private List<PinLinksContinuousSet> sets = new ArrayList<PinLinksContinuousSet>();

    public void add(PinLink pinLink) {
        this.addInternal(pinLink);
        this.merge();
    }

    private void merge() {
        for (int i = 0; i < this.sets.size() - 1; ++i) {
            for (int j = i + 1; j < this.sets.size(); ++j) {
                if (!this.sets.get(i).doesTouch(this.sets.get(j))) continue;
                this.sets.get(i).addAll(this.sets.get(j));
                this.sets.remove(j);
                return;
            }
        }
    }

    private void addInternal(PinLink pinLink) {
        for (PinLinksContinuousSet set : this.sets) {
            if (!set.doesTouch(pinLink)) continue;
            set.add(pinLink);
            return;
        }
        PinLinksContinuousSet newSet = new PinLinksContinuousSet();
        newSet.add(pinLink);
        this.sets.add(newSet);
    }

    public List<Skeleton> createSkeletons() {
        ArrayList<Skeleton> result = new ArrayList<Skeleton>();
        for (PinLinksContinuousSet set : this.sets) {
            result.add(set.createSkeleton());
        }
        return Collections.unmodifiableList(result);
    }
}

