/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.draw;

import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.project.ToTaskDraw;
import znaishaded.net.sourceforge.plantuml.project.core.Task;
import znaishaded.net.sourceforge.plantuml.project.core.TaskImpl;
import znaishaded.net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import znaishaded.net.sourceforge.plantuml.project.draw.PathUtils;
import znaishaded.net.sourceforge.plantuml.project.time.Wink;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TaskDrawRegular
extends AbstractTaskDraw {
    private final Wink end;
    private final boolean oddStart;
    private final boolean oddEnd;
    private final Collection<Wink> paused;
    private final double margin = 2.0;

    public TaskDrawRegular(TimeScale timeScale, double y, String prettyDisplay, Wink start, Wink end, boolean oddStart, boolean oddEnd, ISkinParam skinParam, Task task, ToTaskDraw toTaskDraw) {
        super(timeScale, y, prettyDisplay, start, skinParam, task, toTaskDraw);
        this.end = end;
        this.oddStart = oddStart;
        this.oddEnd = oddEnd;
        this.paused = ((TaskImpl)task).getAllPaused();
    }

    @Override
    public void drawTitle(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        double titleHeight = title.calculateDimension(ug.getStringBounder()).getHeight();
        double h2 = (2.0 + this.getShapeHeight() - titleHeight) / 2.0;
        double endingPosition = this.timeScale.getEndingPosition(this.start);
        title.drawU(ug.apply(new UTranslate(endingPosition, h2)));
    }

    @Override
    protected Style getStyle() {
        Style style = StyleSignature.of(SName.root, SName.element, SName.ganttDiagram, SName.task).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.drawNote(ug.apply(UTranslate.dy(this.getShapeHeight() + 6.0)));
        double startPos = this.timeScale.getStartingPosition(this.start);
        ug = this.applyColors(ug);
        ug = ug.apply(new UTranslate(startPos + 2.0, 2.0));
        this.drawShape(ug);
    }

    private void drawNote(UGraphic ug) {
        if (this.note == null) {
            return;
        }
        Style style = StyleSignature.of(SName.root, SName.element, SName.ganttDiagram, SName.note).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        FontConfiguration fc = new FontConfiguration(style, this.skinParam, null, FontParam.NOTE);
        Sheet sheet = Parser.build(fc, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.skinParam, CreoleMode.FULL).createSheet(this.note);
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        double shadowing = style.value(PName.Shadowing).asDouble();
        Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false);
        opale.drawU(ug);
    }

    private UGraphic applyColors(UGraphic ug) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(ug);
        }
        return ug.apply(this.getLineColor()).apply(this.getBackgroundColor().bg());
    }

    private void drawShape(UGraphic ug) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        double endPos = this.timeScale.getEndingPosition(this.end);
        double fullLength = endPos - startPos - 4.0;
        if (fullLength < 10.0) {
            return;
        }
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.oddStart && !this.oddEnd) {
            ug.draw(PathUtils.UtoRight(fullLength, this.getShapeHeight()));
        } else if (!this.oddStart && this.oddEnd) {
            ug.draw(PathUtils.UtoLeft(fullLength, this.getShapeHeight()));
        } else {
            URectangle full = new URectangle(fullLength, this.getShapeHeight()).rounded(8.0);
            if (this.completion == 100) {
                ug.draw(full);
            } else {
                double partialLength = fullLength * (double)this.completion / 100.0;
                ug.apply(HColorUtils.WHITE).apply(HColorUtils.WHITE.bg()).draw(full);
                if (partialLength > 2.0) {
                    URectangle partial = new URectangle(partialLength, this.getShapeHeight()).rounded(8.0);
                    ug.apply(new HColorNone()).draw(partial);
                }
                if (partialLength > 10.0 && partialLength < fullLength - 10.0) {
                    URectangle patch = new URectangle(8.0, this.getShapeHeight());
                    ug.apply(new HColorNone()).apply(UTranslate.dx(partialLength - 8.0)).draw(patch);
                }
                ug.apply(new HColorNone().bg()).draw(full);
            }
        }
        Wink begin = null;
        for (Wink pause : this.paused) {
            if (this.paused.contains(pause.increment())) {
                if (begin != null) continue;
                begin = pause;
                continue;
            }
            if (begin == null) {
                this.drawPause(ug, pause, pause);
            } else {
                this.drawPause(ug, begin, pause);
            }
            begin = null;
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private void drawPause(UGraphic ug, Wink start1, Wink end) {
        double x1 = this.timeScale.getStartingPosition(start1);
        double x2 = this.timeScale.getEndingPosition(end);
        URectangle small = new URectangle(x2 - x1 - 1.0, this.getShapeHeight() + 1.0);
        ULine line = ULine.hline(x2 - x1 - 1.0);
        ug = ug.apply(UTranslate.dx(x1 - 1.0));
        ug.apply(HColorUtils.WHITE).apply(HColorUtils.WHITE.bg()).draw(small);
        UGraphic ugLine = ug.apply(new UStroke(2.0, 3.0, 1.0));
        ugLine.draw(line);
        ugLine.apply(UTranslate.dy(this.getShapeHeight())).draw(line);
    }
}

