/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.real;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.real.AbstractReal;
import znaishaded.net.sourceforge.plantuml.real.PositiveForce;
import znaishaded.net.sourceforge.plantuml.real.Real;

class RealLine {
    private final List<PositiveForce> forces = new ArrayList<PositiveForce>();
    private double min;
    private double max;
    private Set<AbstractReal> all = new HashSet<AbstractReal>();
    private static int CPT;

    RealLine() {
    }

    void register(double v) {
    }

    void register2(AbstractReal abstractReal) {
        this.all.add(abstractReal);
    }

    public double getAbsoluteMin() {
        return this.min;
    }

    public double getAbsoluteMax() {
        return this.max;
    }

    public void addForce(PositiveForce force) {
        this.forces.add(force);
    }

    public void compile() {
        int cpt = 0;
        HashMap<PositiveForce, Integer> counter = new HashMap<PositiveForce, Integer>();
        do {
            boolean done = true;
            for (PositiveForce f : this.forces) {
                boolean change = f.apply();
                if (!change) continue;
                RealLine.incCounter(counter, f);
                done = false;
            }
            if (!done) continue;
            CPT += cpt;
            this.min = 0.0;
            this.max = 0.0;
            for (AbstractReal real : this.all) {
                double v = real.getCurrentValue();
                if (v > this.max) {
                    this.max = v;
                }
                if (!(v < this.min)) continue;
                this.min = v;
            }
            return;
        } while (++cpt <= 99999);
        this.printCounter(counter);
        throw new IllegalStateException("Inifinite Loop?");
    }

    private void printCounter(Map<PositiveForce, Integer> counter) {
        for (PositiveForce positiveForce : this.forces) {
            System.err.println("force=" + positiveForce);
        }
        for (Map.Entry entry : counter.entrySet()) {
            System.err.println("count=" + entry.getValue() + " for " + entry.getKey());
        }
    }

    private static void incCounter(Map<PositiveForce, Integer> counter, PositiveForce f) {
        Integer v = counter.get(f);
        counter.put(f, v == null ? 1 : v + 1);
    }

    Real asMaxAbsolute() {
        return new MaxAbsolute();
    }

    Real asMinAbsolute() {
        return new MinAbsolute();
    }

    abstract class AbstractAbsolute
    implements Real {
        AbstractAbsolute() {
        }

        @Override
        public void printCreationStackTrace() {
        }

        @Override
        public String getName() {
            return this.getClass().getName();
        }

        @Override
        public Real addFixed(double delta) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Real addAtLeast(double delta) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void ensureBiggerThan(Real other) {
            throw new UnsupportedOperationException();
        }

        public Real getMaxAbsolute() {
            return RealLine.this.asMaxAbsolute();
        }

        public Real getMinAbsolute() {
            return RealLine.this.asMinAbsolute();
        }
    }

    class MinAbsolute
    extends AbstractAbsolute {
        MinAbsolute() {
        }

        @Override
        public double getCurrentValue() {
            return RealLine.this.min;
        }
    }

    class MaxAbsolute
    extends AbstractAbsolute {
        MaxAbsolute() {
        }

        @Override
        public double getCurrentValue() {
            return RealLine.this.max;
        }
    }
}

