/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Grouping;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class GroupingStart
extends Grouping {
    private final List<GroupingLeaf> children = new ArrayList<GroupingLeaf>();
    private final HColor backColorGeneral;
    private final GroupingStart parent;
    private boolean parallel = false;

    public GroupingStart(String title, String comment, HColor backColorGeneral, HColor backColorElement, GroupingStart parent, StyleBuilder styleBuilder) {
        super(title, comment, GroupingType.START, backColorElement, styleBuilder);
        this.backColorGeneral = backColorGeneral;
        this.parent = parent;
    }

    @Override
    public Style[] getUsedStyles() {
        Style[] result = super.getUsedStyles();
        if (result[0] != null) {
            result[0] = result[0].eventuallyOverride(PName.BackGroundColor, this.backColorGeneral);
        }
        return result;
    }

    List<GroupingLeaf> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChildren(GroupingLeaf g2) {
        this.children.add(g2);
    }

    @Override
    public int getLevel() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getLevel() + 1;
    }

    @Override
    public HColor getBackColorGeneral() {
        return this.backColorGeneral;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return false;
    }

    @Override
    public Url getUrl() {
        return null;
    }

    @Override
    public boolean hasUrl() {
        return false;
    }

    @Override
    public boolean isParallel() {
        return this.parallel || this.getTitle().equals("par2");
    }

    public void goParallel() {
        this.parallel = true;
    }
}

