/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.LifeEventType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.ParticipantType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;

public abstract class CommandParticipant
extends SingleLineCommand2<SequenceDiagram> {
    public CommandParticipant(IRegex pattern) {
        super(pattern);
    }

    static IRegex getOrderRegex() {
        return new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("order"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("ORDER", "(-?\\d{1,7})")));
    }

    static IRegex getRegexType() {
        return new RegexOr(new RegexLeaf("TYPE", "(participant|actor|create|boundary|control|entity|queue|database|collections)"), new RegexLeaf("CREATE", "create[%s](participant|actor|boundary|control|entity|queue|database|collections)"));
    }

    @Override
    protected final CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        String error;
        boolean create;
        ParticipantType type;
        String code = arg.get("CODE", 0);
        if (diagram.participantsContainsKey(code)) {
            diagram.putParticipantInLast(code);
            return CommandExecutionResult.ok();
        }
        Display strings = Display.NULL;
        if (arg.get("FULL", 0) != null) {
            strings = Display.getWithNewlines(arg.get("FULL", 0));
        }
        String typeString1 = arg.get("TYPE", 0);
        String typeCreate1 = arg.get("CREATE", 0);
        if (typeCreate1 != null) {
            type = ParticipantType.valueOf(StringUtils.goUpperCase(typeCreate1));
            create = true;
        } else if (typeString1.equalsIgnoreCase("CREATE")) {
            type = ParticipantType.PARTICIPANT;
            create = true;
        } else {
            type = ParticipantType.valueOf(StringUtils.goUpperCase(typeString1));
            create = false;
        }
        String orderString = arg.get("ORDER", 0);
        int order = orderString == null ? 0 : Integer.parseInt(orderString);
        Participant participant = diagram.createNewParticipant(type, code, strings, order);
        String stereotype = arg.get("STEREO", 0);
        if (stereotype != null) {
            ISkinParam skinParam = diagram.getSkinParam();
            boolean stereotypePositionTop = skinParam.stereotypePositionTop();
            UFont font = skinParam.getFont(null, false, FontParam.CIRCLED_CHARACTER);
            participant.setStereotype(new Stereotype(stereotype, skinParam.getCircledCharacterRadius(), font, diagram.getSkinParam().getIHtmlColorSet()), stereotypePositionTop);
        }
        participant.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
        String urlString = arg.get("URL", 0);
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            participant.setUrl(url);
        }
        if (create && (error = diagram.activate(participant, LifeEventType.CREATE, null)) != null) {
            return CommandExecutionResult.error(error);
        }
        return CommandExecutionResult.ok();
    }
}

