/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sprite;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.donors.PSystemDonors;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockHorizontal;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.sprite.RessourcesUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PSystemListInternalSprites
extends AbstractPSystem {
    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        ImageBuilder imageBuilder = ImageBuilder.buildA(new ColorMapperIdentity(), false, null, this.getMetadata(), null, 1.0, HColorUtils.WHITE);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<b>List Current Sprites");
        lines.add("<i>Credit to");
        lines.add("http://www.archimatetool.com");
        lines.add(" ");
        for (String folder : RessourcesUtils.getJarFile("sprites", true)) {
            lines.add("<u>" + folder + "</u> :");
            lines.add(" ");
            for (String png : RessourcesUtils.getJarFile("sprites/" + folder, false)) {
                if (!png.endsWith(".png")) continue;
                String spriteName = png.substring(0, png.length() - 4);
                lines.add("<$archimate/" + spriteName + "> " + spriteName);
            }
        }
        List<TextBlock> cols = PSystemDonors.getCols(lines, 4, 0);
        return new TextBlockHorizontal(cols, VerticalAlignment.TOP);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sprites)");
    }
}

