/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.expression;

import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;

public enum TokenOperator {
    MULTIPLICATION(97, "*"){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.multiply(v2);
        }
    }
    ,
    DIVISION(97, "/"){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.dividedBy(v2);
        }
    }
    ,
    ADDITION(96, "+"){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.add(v2);
        }
    }
    ,
    SUBSTRACTION(96, "-"){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.minus(v2);
        }
    }
    ,
    LESS_THAN(94, "<"){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.lessThan(v2);
        }
    }
    ,
    GREATER_THAN(94, ">"){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.greaterThan(v2);
        }
    }
    ,
    LESS_THAN_OR_EQUALS(94, "<="){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.lessThanOrEquals(v2);
        }
    }
    ,
    GREATER_THAN_OR_EQUALS(94, ">="){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.greaterThanOrEquals(v2);
        }
    }
    ,
    EQUALS(93, "=="){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.equalsOperation(v2);
        }
    }
    ,
    NOT_EQUALS(93, "!="){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.notEquals(v2);
        }
    }
    ,
    LOGICAL_AND(89, "&&"){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.logicalAnd(v2);
        }
    }
    ,
    LOGICAL_OR(88, "||"){

        @Override
        public TValue operate(TValue v1, TValue v2) {
            return v1.logicalOr(v2);
        }
    };

    private final int precedence;
    private final String display;

    private TokenOperator(int precedence, String display) {
        this.precedence = precedence;
        this.display = display;
    }

    public boolean isLeftAssociativity() {
        return true;
    }

    public static TokenOperator getTokenOperator(char ch, char ch2) {
        for (TokenOperator op : TokenOperator.values()) {
            if (op.display.length() != 2 || op.display.charAt(0) != ch || op.display.charAt(1) != ch2) continue;
            return op;
        }
        for (TokenOperator op : TokenOperator.values()) {
            if (op.display.length() != 1 || op.display.charAt(0) != ch) continue;
            return op;
        }
        return null;
    }

    public final int getPrecedence() {
        return this.precedence;
    }

    public abstract TValue operate(TValue var1, TValue var2);

    public final String getDisplay() {
        return this.display;
    }
}

