/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.expression;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.tim.Eater;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TLineType;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.expression.Knowledge;
import znaishaded.net.sourceforge.plantuml.tim.expression.ReversePolishInterpretor;
import znaishaded.net.sourceforge.plantuml.tim.expression.ShuntingYard;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.expression.Token;
import znaishaded.net.sourceforge.plantuml.tim.expression.TokenIterator;
import znaishaded.net.sourceforge.plantuml.tim.expression.TokenType;

public class TokenStack {
    private final List<Token> tokens;

    public boolean isSpecialAffectationWhenFunctionCall() {
        if (this.tokens.size() != 1) {
            return false;
        }
        Token single = this.tokens.get(0);
        if (single.getTokenType() != TokenType.PLAIN_TEXT) {
            return false;
        }
        return TokenStack.isSpecialAffectationWhenFunctionCall(single.getSurface());
    }

    public static boolean isSpecialAffectationWhenFunctionCall(String surface) {
        int idx = surface.indexOf(61);
        if (idx <= 0) {
            return false;
        }
        if (!TLineType.isLetterOrUnderscoreOrDollar(surface.charAt(0))) {
            return false;
        }
        for (int i = 1; i < idx; ++i) {
            if (TLineType.isLetterOrUnderscoreOrDigit(surface.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public TokenStack() {
        this(new ArrayList<Token>());
    }

    private TokenStack(List<Token> list) {
        this.tokens = list;
    }

    public int size() {
        return this.tokens.size();
    }

    public TokenStack subTokenStack(int i) {
        return new TokenStack(Collections.unmodifiableList(this.tokens.subList(i, this.tokens.size())));
    }

    public String toString() {
        return this.tokens.toString();
    }

    public void add(Token token) {
        this.tokens.add(token);
    }

    public TokenStack withoutSpace() {
        TokenStack result = new TokenStack();
        for (Token token : this.tokens) {
            if (token.getTokenType() == TokenType.SPACES) continue;
            result.add(token);
        }
        return result;
    }

    public static TokenStack eatUntilCloseParenthesisOrComma(Eater eater) throws EaterException {
        TokenStack result = new TokenStack();
        int level = 0;
        while (true) {
            eater.skipSpaces();
            char ch = eater.peekChar();
            if (ch == '\u0000') {
                throw EaterException.unlocated("until001");
            }
            if (level == 0 && (ch == ',' || ch == ')')) {
                return result;
            }
            Token token = TokenType.eatOneToken(eater, false);
            TokenType type = token.getTokenType();
            if (type == TokenType.OPEN_PAREN_MATH) {
                ++level;
            } else if (type == TokenType.CLOSE_PAREN_MATH) {
                --level;
            }
            result.add(token);
        }
    }

    public static void eatUntilCloseParenthesisOrComma(TokenIterator it) throws EaterException {
        int level = 0;
        while (true) {
            Token ch;
            if ((ch = it.peekToken()) == null) {
                throw EaterException.unlocated("until002");
            }
            TokenType typech = ch.getTokenType();
            if (level == 0 && (typech == TokenType.COMMA || typech == TokenType.CLOSE_PAREN_MATH) || typech == TokenType.CLOSE_PAREN_FUNC) {
                return;
            }
            Token token = it.nextToken();
            TokenType type = token.getTokenType();
            if (type == TokenType.OPEN_PAREN_MATH || type == TokenType.OPEN_PAREN_FUNC) {
                ++level;
                continue;
            }
            if (type != TokenType.CLOSE_PAREN_MATH && type != TokenType.CLOSE_PAREN_FUNC) continue;
            --level;
        }
    }

    private int countFunctionArg(TokenIterator it) throws EaterException {
        TokenType type1 = it.peekToken().getTokenType();
        if (type1 == TokenType.CLOSE_PAREN_MATH || type1 == TokenType.CLOSE_PAREN_FUNC) {
            return 0;
        }
        int result = 1;
        while (it.hasMoreTokens()) {
            TokenStack.eatUntilCloseParenthesisOrComma(it);
            Token token = it.nextToken();
            TokenType type = token.getTokenType();
            if (type == TokenType.CLOSE_PAREN_MATH || type == TokenType.CLOSE_PAREN_FUNC) {
                return result;
            }
            if (type == TokenType.COMMA) {
                ++result;
                continue;
            }
            throw EaterException.unlocated("count13");
        }
        throw EaterException.unlocated("count12");
    }

    public void guessFunctions() throws EaterException {
        ArrayDeque<Integer> open = new ArrayDeque<Integer>();
        HashMap parens = new HashMap();
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = this.tokens.get(i);
            if (token.getTokenType().equals((Object)TokenType.OPEN_PAREN_MATH)) {
                open.addFirst(i);
                continue;
            }
            if (!token.getTokenType().equals((Object)TokenType.CLOSE_PAREN_MATH)) continue;
            parens.put(open.pollFirst(), i);
        }
        for (Map.Entry ids : parens.entrySet()) {
            int iopen = (Integer)ids.getKey();
            int iclose = (Integer)ids.getValue();
            assert (this.tokens.get(iopen).getTokenType() == TokenType.OPEN_PAREN_MATH);
            assert (this.tokens.get(iclose).getTokenType() == TokenType.CLOSE_PAREN_MATH);
            if (iopen <= 0 || this.tokens.get(iopen - 1).getTokenType() != TokenType.PLAIN_TEXT) continue;
            this.tokens.set(iopen - 1, new Token(this.tokens.get(iopen - 1).getSurface(), TokenType.FUNCTION_NAME, null));
            int nbArg = this.countFunctionArg(this.subTokenStack(iopen + 1).tokenIterator());
            this.tokens.set(iopen, new Token("" + nbArg, TokenType.OPEN_PAREN_FUNC, null));
            this.tokens.set(iclose, new Token(")", TokenType.CLOSE_PAREN_FUNC, null));
        }
    }

    public TokenIterator tokenIterator() {
        return new InternalIterator();
    }

    public TValue getResult(LineLocation location, TContext context, TMemory memory) throws EaterException, EaterExceptionLocated {
        Knowledge knowledge = context.asKnowledge(memory, location);
        TokenStack tmp = this.withoutSpace();
        tmp.guessFunctions();
        TokenIterator it = tmp.tokenIterator();
        ShuntingYard shuntingYard = new ShuntingYard(it, knowledge);
        ReversePolishInterpretor rpn = new ReversePolishInterpretor(location, shuntingYard.getQueue(), knowledge, memory, context);
        return rpn.getResult();
    }

    class InternalIterator
    implements TokenIterator {
        private int pos = 0;

        InternalIterator() {
        }

        @Override
        public Token peekToken() {
            return (Token)TokenStack.this.tokens.get(this.pos);
        }

        @Override
        public Token nextToken() {
            if (!this.hasMoreTokens()) {
                return null;
            }
            return (Token)TokenStack.this.tokens.get(this.pos++);
        }

        @Override
        public boolean hasMoreTokens() {
            return this.pos < TokenStack.this.tokens.size();
        }
    }
}

