/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.PlacementStrategy;

public abstract class AbstractPlacementStrategy
implements PlacementStrategy {
    private final StringBounder stringBounder;
    private final Map<TextBlock, Dimension2D> dimensions = new LinkedHashMap<TextBlock, Dimension2D>();

    public AbstractPlacementStrategy(StringBounder stringBounder) {
        this.stringBounder = stringBounder;
    }

    @Override
    public void add(TextBlock block) {
        this.dimensions.put(block, block.calculateDimension(this.stringBounder));
    }

    protected Map<TextBlock, Dimension2D> getDimensions() {
        return this.dimensions;
    }

    protected double getSumWidth() {
        return this.getSumWidth(this.dimensions.values().iterator());
    }

    protected double getSumHeight() {
        return this.getSumHeight(this.dimensions.values().iterator());
    }

    protected double getMaxHeight() {
        return this.getMaxHeight(this.dimensions.values().iterator());
    }

    protected double getMaxWidth() {
        return this.getMaxWidth(this.dimensions.values().iterator());
    }

    protected double getSumWidth(Iterator<Dimension2D> it) {
        double result = 0.0;
        while (it.hasNext()) {
            result += it.next().getWidth();
        }
        return result;
    }

    protected double getSumHeight(Iterator<Dimension2D> it) {
        double result = 0.0;
        while (it.hasNext()) {
            result += it.next().getHeight();
        }
        return result;
    }

    protected double getMaxWidth(Iterator<Dimension2D> it) {
        double result = 0.0;
        while (it.hasNext()) {
            result = Math.max(result, it.next().getWidth());
        }
        return result;
    }

    protected double getMaxHeight(Iterator<Dimension2D> it) {
        double result = 0.0;
        while (it.hasNext()) {
            result = Math.max(result, it.next().getHeight());
        }
        return result;
    }

    protected final StringBounder getStringBounder() {
        return this.stringBounder;
    }
}

