/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.comp;

import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.CenteredText;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.UGraphicDelegator;
import znaishaded.net.sourceforge.plantuml.ugraphic.UBackground;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChange;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.comp.CompressionMode;
import znaishaded.net.sourceforge.plantuml.ugraphic.comp.PiecewiseAffineTransform;

public class UGraphicCompressOnXorY
extends UGraphicDelegator {
    private final CompressionMode mode;
    private final PiecewiseAffineTransform compressionTransform;
    private final UTranslate translate;

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new UGraphicCompressOnXorY(this.mode, this.getUg(), this.compressionTransform, this.translate.compose((UTranslate)change));
        }
        if (change instanceof UStroke || change instanceof UBackground || change instanceof HColor) {
            return new UGraphicCompressOnXorY(this.mode, this.getUg().apply(change), this.compressionTransform, this.translate);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "UGraphicCompressOnXorY " + (Object)((Object)this.mode);
    }

    public UGraphicCompressOnXorY(CompressionMode mode, UGraphic ug, PiecewiseAffineTransform compressionTransform) {
        this(mode, ug, compressionTransform, new UTranslate());
    }

    private UGraphicCompressOnXorY(CompressionMode mode, UGraphic ug, PiecewiseAffineTransform compressionTransform, UTranslate translate) {
        super(ug);
        this.mode = mode;
        this.compressionTransform = compressionTransform;
        this.translate = translate;
    }

    @Override
    public void draw(UShape shape) {
        double x = this.translate.getDx();
        double y = this.translate.getDy();
        if (shape instanceof URectangle) {
            URectangle rect = (URectangle)shape;
            if (this.mode == CompressionMode.ON_X) {
                double x2 = this.ct(x + rect.getWidth());
                shape = rect.withWidth(x2 - this.ct(x));
            } else {
                double y2 = this.ct(y + rect.getHeight());
                shape = rect.withHeight(y2 - this.ct(y));
            }
        }
        if (shape instanceof CenteredText) {
            CenteredText centeredText = (CenteredText)shape;
            TextBlock text = centeredText.getText();
            double totalWidth = centeredText.getTotalWidth();
            double realSpaceWidth = this.mode == CompressionMode.ON_X ? this.ct(x + totalWidth) - this.ct(x) : totalWidth;
            double textWidth = text.calculateDimension(this.getStringBounder()).getWidth();
            double pos = (realSpaceWidth - textWidth) / 2.0;
            text.drawU(this.getUg().apply(this.getTranslate(x, y)).apply(UTranslate.dx(pos)));
            return;
        }
        if (shape instanceof ULine) {
            this.drawLine(x, y, (ULine)shape);
        } else {
            this.getUg().apply(this.getTranslate(x, y)).draw(shape);
        }
    }

    private UTranslate getTranslate(double x, double y) {
        if (this.mode == CompressionMode.ON_X) {
            return new UTranslate(this.ct(x), y);
        }
        return new UTranslate(x, this.ct(y));
    }

    private void drawLine(double x, double y, ULine shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.drawLine(this.ct(x), y, this.ct(x + shape.getDX()), y + shape.getDY());
        } else {
            this.drawLine(x, this.ct(y), x + shape.getDX(), this.ct(y + shape.getDY()));
        }
    }

    private double ct(double v) {
        return this.compressionTransform.transform(v);
    }

    private void drawLine(double x1, double y1, double x2, double y2) {
        if (y1 > y2) {
            this.drawLine(x2, y2, x1, y1);
            return;
        }
        assert (y1 <= y2);
        this.getUg().apply(new UTranslate(x1, y1)).draw(new ULine(x2 - x1, y2 - y1));
    }
}

