/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.ext.gfm.tables.internal;

import java.util.Collections;
import java.util.Map;
import znaishaded.org.commonmark.ext.gfm.tables.TableBlock;
import znaishaded.org.commonmark.ext.gfm.tables.TableBody;
import znaishaded.org.commonmark.ext.gfm.tables.TableCell;
import znaishaded.org.commonmark.ext.gfm.tables.TableHead;
import znaishaded.org.commonmark.ext.gfm.tables.TableRow;
import znaishaded.org.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.renderer.html.HtmlNodeRendererContext;
import znaishaded.org.commonmark.renderer.html.HtmlWriter;

public class TableHtmlNodeRenderer
extends TableNodeRenderer {
    private final HtmlWriter htmlWriter;
    private final HtmlNodeRendererContext context;

    public TableHtmlNodeRenderer(HtmlNodeRendererContext context) {
        this.htmlWriter = context.getWriter();
        this.context = context;
    }

    @Override
    protected void renderBlock(TableBlock tableBlock) {
        this.htmlWriter.line();
        this.htmlWriter.tag("table", this.getAttributes(tableBlock, "table"));
        this.renderChildren(tableBlock);
        this.htmlWriter.tag("/table");
        this.htmlWriter.line();
    }

    @Override
    protected void renderHead(TableHead tableHead) {
        this.htmlWriter.line();
        this.htmlWriter.tag("thead", this.getAttributes(tableHead, "thead"));
        this.renderChildren(tableHead);
        this.htmlWriter.tag("/thead");
        this.htmlWriter.line();
    }

    @Override
    protected void renderBody(TableBody tableBody) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tbody", this.getAttributes(tableBody, "tbody"));
        this.renderChildren(tableBody);
        this.htmlWriter.tag("/tbody");
        this.htmlWriter.line();
    }

    @Override
    protected void renderRow(TableRow tableRow) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tr", this.getAttributes(tableRow, "tr"));
        this.renderChildren(tableRow);
        this.htmlWriter.tag("/tr");
        this.htmlWriter.line();
    }

    @Override
    protected void renderCell(TableCell tableCell) {
        String tagName = tableCell.isHeader() ? "th" : "td";
        this.htmlWriter.line();
        this.htmlWriter.tag(tagName, this.getCellAttributes(tableCell, tagName));
        this.renderChildren(tableCell);
        this.htmlWriter.tag("/" + tagName);
        this.htmlWriter.line();
    }

    private Map<String, String> getAttributes(Node node, String tagName) {
        return this.context.extendAttributes(node, tagName, Collections.emptyMap());
    }

    private Map<String, String> getCellAttributes(TableCell tableCell, String tagName) {
        if (tableCell.getAlignment() != null) {
            return this.context.extendAttributes(tableCell, tagName, Collections.singletonMap("align", TableHtmlNodeRenderer.getAlignValue(tableCell.getAlignment())));
        }
        return this.context.extendAttributes(tableCell, tagName, Collections.emptyMap());
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

