/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.utils.StringUtils;

class TextContentExtractor {
    private TextContentExtractor() {
    }

    public static String extractText(String contentId, String content, PluginParamsOpts opts) {
        if (opts.isEmpty()) {
            return content;
        }
        Text text = new Text(contentId, content);
        Text croppedAtStart = TextContentExtractor.cropStart(text, opts);
        Text croppedAtEnd = TextContentExtractor.cropEnd(croppedAtStart, opts);
        Text withExcludedStartEnd = TextContentExtractor.excludeStartEnd(croppedAtEnd, opts);
        Text withIncludeRegexp = TextContentExtractor.includeRegexp(withExcludedStartEnd, opts);
        Text withExcludedRegexp = TextContentExtractor.excludeRegexp(withIncludeRegexp, opts);
        return StringUtils.stripIndentation(withExcludedRegexp.toString());
    }

    private static Text cropStart(Text text, PluginParamsOpts opts) {
        String startLine = (String)opts.get("startLine");
        if (startLine == null) {
            return text;
        }
        return text.startingWithLineContaining(startLine);
    }

    private static Text cropEnd(Text text, PluginParamsOpts opts) {
        Number numberOfLines = (Number)opts.get("numberOfLines");
        if (numberOfLines != null) {
            return text.limitTo(numberOfLines);
        }
        String endLine = (String)opts.get("endLine");
        if (endLine != null) {
            return text.limitToLineContaining(endLine);
        }
        return text;
    }

    private static Text excludeStartEnd(Text text, PluginParamsOpts opts) {
        Boolean exclude = opts.get("excludeStartEnd", false);
        if (!exclude.booleanValue()) {
            return text;
        }
        boolean hasStartLine = opts.has("startLine");
        boolean hasEndLine = opts.has("endLine");
        if (hasStartLine && hasEndLine || !hasStartLine && !hasEndLine) {
            return text.cropOneLineFromStartAndEnd();
        }
        if (hasStartLine) {
            return text.cropOneLineFromStart();
        }
        return text.cropOneLineFromEnd();
    }

    private static Text includeRegexp(Text text, PluginParamsOpts opts) {
        List<String> includeRegexps = opts.getList("includeRegexp");
        if (includeRegexps.isEmpty()) {
            return text;
        }
        return text.includeRegexp(TextContentExtractor.createListOfPatterns(includeRegexps));
    }

    private static Text excludeRegexp(Text text, PluginParamsOpts opts) {
        List<String> excludeRegexps = opts.getList("excludeRegexp");
        if (excludeRegexps.isEmpty()) {
            return text;
        }
        return text.excludeRegexp(TextContentExtractor.createListOfPatterns(excludeRegexps));
    }

    private static List<Pattern> createListOfPatterns(List<String> regexps) {
        return regexps.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    private static class Text {
        private final String contentId;
        private final List<String> lines;
        private final boolean hasCroppedStart;

        public Text(String contentId, String text) {
            this(contentId, Arrays.asList(text.split("\n")), false);
        }

        public Text(String contentId, List<String> lines, boolean hasCroppedStart) {
            this.contentId = contentId;
            this.lines = lines;
            this.hasCroppedStart = hasCroppedStart;
        }

        Text startingWithLineContaining(String subLine) {
            int lineIdx = this.findLineIdxContaining(subLine);
            return this.newText(this.lines.subList(lineIdx, this.lines.size()), true);
        }

        Text limitToLineContaining(String subLine) {
            int lineIdx = this.findLineIdxContaining(subLine);
            return this.newText(this.lines.subList(0, lineIdx + 1));
        }

        Text limitTo(Number numberOfLines) {
            return this.newText(this.lines.subList(0, numberOfLines.intValue()));
        }

        Text cropOneLineFromStartAndEnd() {
            return this.newText(this.lines.subList(1, this.lines.size() - 1));
        }

        Text cropOneLineFromStart() {
            return this.newText(this.lines.subList(1, this.lines.size()));
        }

        Text cropOneLineFromEnd() {
            return this.newText(this.lines.subList(0, this.lines.size() - 1));
        }

        Text includeRegexp(List<Pattern> regexps) {
            return this.newText(this.lines.stream().filter(line -> regexps.stream().anyMatch(r -> r.matcher((CharSequence)line).find())).collect(Collectors.toList()));
        }

        Text excludeRegexp(List<Pattern> regexps) {
            return this.newText(this.lines.stream().filter(line -> regexps.stream().noneMatch(r -> r.matcher((CharSequence)line).find())).collect(Collectors.toList()));
        }

        private Text newText(List<String> lines) {
            return new Text(this.contentId, lines, false);
        }

        private Text newText(List<String> lines, boolean hasCroppedStart) {
            return new Text(this.contentId, lines, hasCroppedStart);
        }

        private int findLineIdxContaining(String subLine) {
            int i;
            int n = i = this.hasCroppedStart ? 1 : 0;
            while (i < this.lines.size()) {
                if (this.lines.get(i).contains(subLine)) {
                    return i;
                }
                ++i;
            }
            throw new IllegalArgumentException("there is no line containing \"" + subLine + "\" in <" + this.contentId + ">:\n" + this.toString());
        }

        public String toString() {
            return String.join((CharSequence)"\n", this.lines);
        }
    }
}

