/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.parser;

import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.java.parser.JavaMethodParam;
import org.testingisdocumenting.znai.java.parser.JavaMethodReturn;

public class JavaMethod {
    private final String name;
    private final String nameWithTypes;
    private final String fullBody;
    private final String bodyOnly;
    private final String signatureOnly;
    private final String javaDocText;
    private final List<JavaMethodParam> params;
    private final JavaMethodReturn javaMethodReturn;
    private final String anchorPrefix;

    public JavaMethod(String name, String fullBody, String bodyOnly, String signatureOnly, List<JavaMethodParam> params, JavaMethodReturn javaMethodReturn, String javaDocText) {
        this.name = name;
        this.nameWithTypes = name + "(" + params.stream().map(JavaMethodParam::getType).collect(Collectors.joining(",")) + ")";
        this.fullBody = fullBody;
        this.bodyOnly = bodyOnly;
        this.signatureOnly = signatureOnly;
        this.javaDocText = javaDocText;
        this.params = params;
        this.javaMethodReturn = javaMethodReturn != null && javaMethodReturn.getType().equals("void") ? null : javaMethodReturn;
        this.anchorPrefix = this.buildAnchorPrefix();
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithTypes() {
        return this.nameWithTypes;
    }

    public String getFullBody() {
        return this.fullBody;
    }

    public String getBodyOnly() {
        return this.bodyOnly;
    }

    public String getJavaDocText() {
        return this.javaDocText;
    }

    public String getSignatureOnly() {
        return this.signatureOnly;
    }

    public List<JavaMethodParam> getParams() {
        return this.params;
    }

    public JavaMethodReturn getJavaMethodReturn() {
        return this.javaMethodReturn;
    }

    public List<String> getParamNames() {
        return this.params.stream().map(JavaMethodParam::getName).collect(Collectors.toList());
    }

    public String getAnchorPrefix() {
        return this.anchorPrefix;
    }

    private String buildAnchorPrefix() {
        String fromParams = this.params.stream().map(p -> p.getName() + "_" + p.getType()).collect(Collectors.joining("_"));
        return this.name + (fromParams.isEmpty() ? "" : "_" + fromParams);
    }
}

