/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.netty.handler.codec.dns;

import java.net.InetSocketAddress;
import java.util.List;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.socket.DatagramPacket;
import znaishaded.io.netty.handler.codec.MessageToMessageDecoder;
import znaishaded.io.netty.handler.codec.dns.DatagramDnsResponse;
import znaishaded.io.netty.handler.codec.dns.DnsOpCode;
import znaishaded.io.netty.handler.codec.dns.DnsRecordDecoder;
import znaishaded.io.netty.handler.codec.dns.DnsResponse;
import znaishaded.io.netty.handler.codec.dns.DnsResponseCode;
import znaishaded.io.netty.handler.codec.dns.DnsResponseDecoder;

@ChannelHandler.Sharable
public class DatagramDnsResponseDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final DnsResponseDecoder<InetSocketAddress> responseDecoder;

    public DatagramDnsResponseDecoder() {
        this(DnsRecordDecoder.DEFAULT);
    }

    public DatagramDnsResponseDecoder(DnsRecordDecoder recordDecoder) {
        this.responseDecoder = new DnsResponseDecoder<InetSocketAddress>(recordDecoder){

            @Override
            protected DnsResponse newResponse(InetSocketAddress sender, InetSocketAddress recipient, int id, DnsOpCode opCode, DnsResponseCode responseCode) {
                return new DatagramDnsResponse(sender, recipient, id, opCode, responseCode);
            }
        };
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
        out.add(this.decodeResponse(ctx, packet));
    }

    protected DnsResponse decodeResponse(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        return this.responseDecoder.decode((InetSocketAddress)packet.sender(), (InetSocketAddress)packet.recipient(), (ByteBuf)packet.content());
    }
}

