/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.json.pointer.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import znaishaded.io.vertx.core.json.pointer.JsonPointer;
import znaishaded.io.vertx.core.json.pointer.JsonPointerIterator;

public class JsonPointerImpl
implements JsonPointer {
    public static final Pattern VALID_POINTER_PATTERN = Pattern.compile("^(/(([^/~])|(~[01]))*)*$");
    URI startingUri;
    List<String> decodedTokens;

    public JsonPointerImpl(URI uri) {
        this.startingUri = this.removeFragment(uri);
        this.decodedTokens = this.parse(uri.getFragment());
    }

    public JsonPointerImpl(String pointer) {
        this.startingUri = URI.create("#");
        this.decodedTokens = this.parse(pointer);
    }

    public JsonPointerImpl() {
        this.startingUri = URI.create("#");
        this.decodedTokens = this.parse(null);
    }

    protected JsonPointerImpl(URI startingUri, List<String> decodedTokens) {
        this.startingUri = startingUri;
        this.decodedTokens = new ArrayList<String>(decodedTokens);
    }

    private ArrayList<String> parse(String pointer) {
        if (pointer == null || "".equals(pointer)) {
            return new ArrayList<String>();
        }
        if (VALID_POINTER_PATTERN.matcher(pointer).matches()) {
            return Arrays.stream(pointer.split("\\/", -1)).skip(1L).map(this::unescape).collect(Collectors.toCollection(ArrayList::new));
        }
        throw new IllegalArgumentException("The provided pointer is not a valid JSON Pointer");
    }

    private String escape(String path) {
        return path.replace("~", "~0").replace("/", "~1");
    }

    private String unescape(String path) {
        return path.replace("~1", "/").replace("~0", "~");
    }

    @Override
    public boolean isRootPointer() {
        return this.decodedTokens.size() == 0;
    }

    @Override
    public boolean isLocalPointer() {
        return this.startingUri == null || this.startingUri.getSchemeSpecificPart() == null || this.startingUri.getSchemeSpecificPart().isEmpty();
    }

    @Override
    public boolean isParent(JsonPointer c) {
        JsonPointerImpl child = (JsonPointerImpl)c;
        return child != null && (child.getURIWithoutFragment() == null && this.getURIWithoutFragment() == null || child.getURIWithoutFragment().equals(this.getURIWithoutFragment())) && this.decodedTokens.size() < child.decodedTokens.size() && IntStream.range(0, this.decodedTokens.size()).mapToObj(i -> this.decodedTokens.get(i).equals(child.decodedTokens.get(i))).reduce(Boolean::logicalAnd).orElse(true) != false;
    }

    @Override
    public String toString() {
        if (this.isRootPointer()) {
            return "";
        }
        return "/" + String.join((CharSequence)"/", this.decodedTokens.stream().map(this::escape).collect(Collectors.toList()));
    }

    @Override
    public URI toURI() {
        if (this.isRootPointer()) {
            return this.replaceFragment(this.startingUri, "");
        }
        return this.replaceFragment(this.startingUri, "/" + String.join((CharSequence)"/", this.decodedTokens.stream().map(this::escape).collect(Collectors.toList())));
    }

    @Override
    public URI getURIWithoutFragment() {
        return this.startingUri;
    }

    @Override
    public JsonPointer append(String path) {
        this.decodedTokens.add(path);
        return this;
    }

    @Override
    public JsonPointer append(int i) {
        return this.append(Integer.toString(i));
    }

    @Override
    public JsonPointer append(List<String> paths) {
        this.decodedTokens.addAll(paths);
        return this;
    }

    @Override
    public JsonPointer append(JsonPointer pointer) {
        this.decodedTokens.addAll(((JsonPointerImpl)pointer).decodedTokens);
        return this;
    }

    @Override
    public JsonPointer parent() {
        if (!this.isRootPointer()) {
            this.decodedTokens.remove(this.decodedTokens.size() - 1);
        }
        return this;
    }

    @Override
    public JsonPointer copy() {
        return new JsonPointerImpl(this.startingUri, this.decodedTokens);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPointerImpl that = (JsonPointerImpl)o;
        return Objects.equals(this.startingUri, that.startingUri) && Objects.equals(this.decodedTokens, that.decodedTokens);
    }

    public int hashCode() {
        return Objects.hash(this.startingUri, this.decodedTokens);
    }

    @Override
    public Object queryOrDefault(Object value, JsonPointerIterator iterator, Object defaultValue) {
        if (this.isRootPointer()) {
            return iterator.isNull(value) ? defaultValue : value;
        }
        value = this.walkTillLastElement(value, iterator, false, null);
        String lastKey = this.decodedTokens.get(this.decodedTokens.size() - 1);
        if (iterator.isObject(value)) {
            Object finalValue = iterator.getObjectParameter(value, lastKey, false);
            return !iterator.isNull(finalValue) ? finalValue : defaultValue;
        }
        if (iterator.isArray(value) && !"-".equals(lastKey)) {
            try {
                Object finalValue = iterator.getArrayElement(value, Integer.parseInt(lastKey));
                return !iterator.isNull(finalValue) ? finalValue : defaultValue;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    @Override
    public List<Object> tracedQuery(Object objectToQuery, JsonPointerIterator iterator) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.isRootPointer() && !iterator.isNull(objectToQuery)) {
            list.add(objectToQuery);
        } else {
            Object lastValue = this.walkTillLastElement(objectToQuery, iterator, false, list::add);
            if (!iterator.isNull(lastValue)) {
                list.add(lastValue);
            }
            String lastKey = this.decodedTokens.get(this.decodedTokens.size() - 1);
            if (iterator.isObject(lastValue)) {
                lastValue = iterator.getObjectParameter(lastValue, lastKey, false);
            } else if (iterator.isArray(lastValue) && !"-".equals(lastKey)) {
                try {
                    lastValue = iterator.getArrayElement(lastValue, Integer.parseInt(lastKey));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!iterator.isNull(lastValue)) {
                list.add(lastValue);
            }
        }
        return list;
    }

    @Override
    public Object write(Object valueToWrite, JsonPointerIterator iterator, Object newElement, boolean createOnMissing) {
        if (this.isRootPointer()) {
            return iterator.isNull(valueToWrite) ? null : newElement;
        }
        Object walkedValue = this.walkTillLastElement(valueToWrite, iterator, createOnMissing, null);
        if (this.writeLastElement(walkedValue, iterator, newElement)) {
            return valueToWrite;
        }
        return null;
    }

    private Object walkTillLastElement(Object value, JsonPointerIterator iterator, boolean createOnMissing, Consumer<Object> onNewValue) {
        for (int i = 0; i < this.decodedTokens.size() - 1; ++i) {
            String k = this.decodedTokens.get(i);
            if (i == 0 && "".equals(k)) continue;
            if (iterator.isObject(value)) {
                if (onNewValue != null) {
                    onNewValue.accept(value);
                }
                value = iterator.getObjectParameter(value, k, createOnMissing);
                continue;
            }
            if (iterator.isArray(value)) {
                if (onNewValue != null) {
                    onNewValue.accept(value);
                }
                try {
                    value = iterator.getArrayElement(value, Integer.parseInt(k));
                    if (!iterator.isNull(value) || !createOnMissing) continue;
                    value = iterator.getObjectParameter(value, k, true);
                }
                catch (NumberFormatException e) {
                    value = null;
                }
                continue;
            }
            return null;
        }
        return value;
    }

    private boolean writeLastElement(Object valueToWrite, JsonPointerIterator iterator, Object newElement) {
        String lastKey = this.decodedTokens.get(this.decodedTokens.size() - 1);
        if (iterator.isObject(valueToWrite)) {
            return iterator.writeObjectParameter(valueToWrite, lastKey, newElement);
        }
        if (iterator.isArray(valueToWrite)) {
            if ("-".equals(lastKey)) {
                return iterator.appendArrayElement(valueToWrite, newElement);
            }
            try {
                return iterator.writeArrayElement(valueToWrite, Integer.parseInt(lastKey), newElement);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private URI removeFragment(URI oldURI) {
        return this.replaceFragment(oldURI, null);
    }

    private URI replaceFragment(URI oldURI, String fragment) {
        try {
            if (oldURI != null) {
                return new URI(oldURI.getScheme(), oldURI.getSchemeSpecificPart(), fragment);
            }
            return new URI(null, null, fragment);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

