/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileHeightFixedCentered
extends AbstractFtile {
    private final Ftile tile;
    private final double fixedHeight;

    public FtileHeightFixedCentered(Ftile tile, double fixedHeight) {
        super(tile.skinParam());
        this.tile = tile;
        this.fixedHeight = fixedHeight;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return this.tile.getOutLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return this.tile.calculateDimension(stringBounder).translate(this.getTranslate(stringBounder)).fixedHeight(this.fixedHeight);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        FtileGeometry dim = this.tile.calculateDimension(stringBounder);
        if (((Dimension2D)dim).getHeight() > this.fixedHeight) {
            throw new IllegalStateException();
        }
        return UTranslate.dy((this.fixedHeight - ((Dimension2D)dim).getHeight()) / 2.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(this.getTranslate(ug.getStringBounder())).draw(this.tile);
    }
}

