/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class ConnectionVerticalDown
extends AbstractConnection
implements ConnectionTranslatable {
    private final Point2D p1;
    private final Point2D p2;
    private final Rainbow color;
    private final TextBlock textBlock;

    public ConnectionVerticalDown(Ftile ftile1, Ftile ftile2, Point2D p1, Point2D p2, Rainbow color, TextBlock textBlock) {
        super(ftile1, ftile2);
        if (color.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.p1 = p1;
        this.p2 = p2;
        this.color = color;
        this.textBlock = textBlock;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.draw(this.getSimpleSnake());
    }

    public double getMaxX(StringBounder stringBounder) {
        return this.getSimpleSnake().getMaxX(stringBounder);
    }

    private Snake getSimpleSnake() {
        Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, Arrows.asToDown());
        snake.setLabel(this.textBlock);
        snake.addPoint(this.p1);
        snake.addPoint(this.p2);
        return snake;
    }

    @Override
    public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
        Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, Arrows.asToDown());
        snake.setLabel(this.textBlock);
        Point2D mp1a = translate1.getTranslated(this.p1);
        Point2D mp2b = translate2.getTranslated(this.p2);
        double middle = (mp1a.getY() + mp2b.getY()) / 2.0;
        snake.addPoint(mp1a);
        snake.addPoint(mp1a.getX(), middle);
        snake.addPoint(mp2b.getX(), middle);
        snake.addPoint(mp2b);
        ug.draw(snake);
    }
}

