/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.command;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleFontFamilyChange
implements Command {
    private final Pattern2 pattern;

    public static Command create() {
        return new CommandCreoleFontFamilyChange("^(?i)(\\<font[\\s:]+([^>]+)/?\\>(.*?)\\</font\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleFontFamilyChange("^(?i)(\\<font[\\s:]+([^>]+)/?\\>(.*)$)");
    }

    private CommandCreoleFontFamilyChange(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        String family = m3.group(2);
        FontConfiguration fc2 = fc1.changeFamily(family);
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m3.group(3));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m3.group(1).length());
    }
}

