/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.rosetta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.creole.rosetta.ReaderWiki;
import znaishaded.net.sourceforge.plantuml.creole.rosetta.WikiLanguage;

public abstract class ReaderAbstractWiki
implements ReaderWiki {
    protected static final String PNG_OR_GIF = "([-_\\w]+\\.(?:png|gif))";
    protected static final String BRACKET1 = "\\[([^\\[\\]]+?)\\]";
    protected static final String BRACKET0 = "\\[([^\\[\\]]*?)\\]";

    public final List<String> transform(String ... data) {
        return this.transform(Arrays.asList(data));
    }

    protected final String rawCode(String s2, String start, String end) {
        StringBuilder sb = new StringBuilder(s2.length());
        boolean rawMode = false;
        boolean rawInRaw = false;
        for (int i = 0; i < s2.length(); ++i) {
            if (!rawMode && s2.substring(i).startsWith(start)) {
                rawMode = true;
                rawInRaw = false;
                sb.append(WikiLanguage.UNICODE.tag("code"));
                if (!s2.substring((i += start.length() - 1) + 1).startsWith(start)) continue;
                i += start.length();
                sb.append(WikiLanguage.hideCharsF7(start));
                rawInRaw = true;
                continue;
            }
            if (rawMode && s2.substring(i).startsWith(end) && !s2.substring(i + 1).startsWith(end)) {
                rawMode = false;
                if (rawInRaw && s2.substring((i += end.length() - 1) + 1).startsWith(end)) {
                    i += end.length();
                    sb.append(WikiLanguage.hideCharsF7(end));
                }
                sb.append(WikiLanguage.UNICODE.slashTag("code"));
                rawInRaw = false;
                continue;
            }
            char ch = s2.charAt(i);
            if (rawMode) {
                ch = WikiLanguage.toF7(ch);
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    protected final String cleanAndHideBackslashSeparator(String s2, String sep, String unicodeSep) {
        if ((s2 = s2.trim()).startsWith(sep)) {
            s2 = s2.substring(1);
        }
        if (s2.endsWith(sep)) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        s2 = s2.trim();
        if (!sep.equals("^") && !sep.equals("|")) {
            throw new IllegalArgumentException();
        }
        String regex = "\\\\\\" + sep;
        s2 = s2.replaceAll(regex, unicodeSep);
        s2 = this.singleLineFormat(s2.trim());
        s2 = s2.replace(sep, " " + sep + " ");
        return s2;
    }

    protected abstract String singleLineFormat(String var1);

    protected final void exportCodeInternal(List<String> uhtml, String tag, List<String> lines) {
        uhtml.add(WikiLanguage.UNICODE.tag(tag));
        for (String s2 : lines) {
            uhtml.add(s2);
        }
        uhtml.add(WikiLanguage.UNICODE.slashTag(tag));
    }

    protected final void exportCodeInternalEnsureStartuml(List<String> uhtml, String tag, List<String> lines) {
        this.exportCodeInternal(uhtml, tag, this.ensureStartuml(lines));
    }

    private List<String> ensureStartuml(List<String> lines) {
        String first = lines.get(0);
        if (first.startsWith("@start")) {
            return lines;
        }
        ArrayList<String> copy = new ArrayList<String>(lines);
        copy.add(0, "@startuml");
        copy.add("@enduml");
        return copy;
    }
}

