/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import znaishaded.net.sourceforge.plantuml.EmbeddedDiagram;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockVertical2;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;

public class BodyEnhanced
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private TextBlock area;
    private final FontConfiguration titleConfig;
    private final List<CharSequence> rawBody;
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final boolean lineFirst;
    private final HorizontalAlignment align;
    private final boolean manageHorizontalLine;
    private final boolean manageModifier;
    private final List<Url> urls = new ArrayList<Url>();
    private final Stereotype stereotype;
    private final ILeaf entity;
    private final boolean inEllipse;
    private final double minClassWidth;
    private final SName diagramType;

    public BodyEnhanced(List<String> rawBody, FontParam fontParam, ISkinParam skinParam, boolean manageModifier, Stereotype stereotype, ILeaf entity, SName diagramType) {
        this.diagramType = diagramType;
        this.rawBody = new ArrayList<String>(rawBody);
        this.stereotype = stereotype;
        this.fontParam = fontParam;
        this.skinParam = skinParam;
        this.titleConfig = new FontConfiguration(skinParam, fontParam, stereotype);
        this.lineFirst = true;
        this.align = skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT);
        this.manageHorizontalLine = true;
        this.manageModifier = manageModifier;
        this.entity = entity;
        this.inEllipse = false;
        this.minClassWidth = 0.0;
    }

    public BodyEnhanced(Display display, FontParam fontParam, ISkinParam skinParam, HorizontalAlignment align, Stereotype stereotype, boolean manageHorizontalLine, boolean manageModifier, ILeaf entity, SName diagramType) {
        this(display, fontParam, skinParam, align, stereotype, manageHorizontalLine, manageHorizontalLine, entity, 0.0, diagramType);
    }

    public BodyEnhanced(Display display, FontParam fontParam, ISkinParam skinParam, HorizontalAlignment align, Stereotype stereotype, boolean manageHorizontalLine, boolean manageModifier, ILeaf entity, double minClassWidth, SName diagramType) {
        this.diagramType = diagramType;
        this.minClassWidth = minClassWidth;
        this.entity = entity;
        this.stereotype = stereotype;
        this.rawBody = new ArrayList<CharSequence>();
        this.fontParam = fontParam;
        this.skinParam = skinParam;
        this.titleConfig = new FontConfiguration(skinParam, fontParam, stereotype);
        this.lineFirst = false;
        this.align = skinParam.getDefaultTextAlignment(align);
        this.manageHorizontalLine = manageHorizontalLine;
        this.manageModifier = manageModifier;
        boolean bl = this.inEllipse = fontParam == FontParam.USECASE;
        if (manageHorizontalLine && this.inEllipse && display.size() > 0 && BodyEnhanced.isBlockSeparator(display.get(0).toString())) {
            this.rawBody.add("");
        }
        for (CharSequence s2 : display) {
            this.rawBody.add(s2);
        }
    }

    private TextBlock decorate(StringBounder stringBounder, TextBlock b, char separator, TextBlock title) {
        if (separator == '\u0000') {
            return b;
        }
        if (title == null) {
            return new TextBlockLineBefore(TextBlockUtils.withMargin(b, 6.0, 4.0), separator);
        }
        Dimension2D dimTitle = title.calculateDimension(stringBounder);
        TextBlockLineBefore raw = new TextBlockLineBefore(TextBlockUtils.withMargin(b, 6.0, 6.0, dimTitle.getHeight() / 2.0, 4.0), separator, title);
        return TextBlockUtils.withMargin(raw, 0.0, 0.0, dimTitle.getHeight() / 2.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    private TextBlock getArea(StringBounder stringBounder) {
        if (this.area != null) {
            return this.area;
        }
        this.urls.clear();
        ArrayList<TextBlock> blocks = new ArrayList<TextBlock>();
        char separator = this.lineFirst ? (char)'_' : '\u0000';
        TextBlock title = null;
        ArrayList<Member> members = new ArrayList<Member>();
        ListIterator<CharSequence> it = this.rawBody.listIterator();
        while (it.hasNext()) {
            CharSequence s2 = it.next();
            if (s2 instanceof EmbeddedDiagram) {
                blocks.add(((EmbeddedDiagram)s2).asDraw(this.skinParam));
                continue;
            }
            String s3 = s2.toString();
            if (this.manageHorizontalLine && BodyEnhanced.isBlockSeparator(s3)) {
                blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.diagramType), separator, title));
                separator = s3.charAt(0);
                title = this.getTitle(s3, this.skinParam);
                members = new ArrayList();
                continue;
            }
            if (Parser.isTreeStart(s3)) {
                if (members.size() > 0) {
                    blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.diagramType), separator, title));
                }
                members = new ArrayList();
                List<CharSequence> allTree = BodyEnhanced.buildAllTree(s3, it);
                TextBlock bloc = Display.create(allTree).create7(this.fontParam.getFontConfiguration(this.skinParam), this.align, this.skinParam, CreoleMode.FULL);
                blocks.add(bloc);
                continue;
            }
            Member m3 = new Member(s3, Member.isMethod(s3), this.manageModifier);
            members.add(m3);
            if (m3.getUrl() == null) continue;
            this.urls.add(m3.getUrl());
        }
        if (this.inEllipse && members.size() == 0) {
            members.add(new Member("", false, false));
        }
        blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.diagramType), separator, title));
        this.area = blocks.size() == 1 ? (TextBlock)blocks.get(0) : new TextBlockVertical2(blocks, this.align);
        if (this.minClassWidth > 0.0) {
            this.area = TextBlockUtils.withMinWidth(this.area, this.minClassWidth, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT));
        }
        return this.area;
    }

    private static List<CharSequence> buildAllTree(String init, ListIterator<CharSequence> it) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        result.add(init);
        while (it.hasNext()) {
            CharSequence s2 = it.next();
            if (Parser.isTreeStart(StringUtils.trinNoTrace(s2))) {
                result.add(s2);
                continue;
            }
            it.previous();
            return result;
        }
        return result;
    }

    public static boolean isBlockSeparator(String s2) {
        if (s2.startsWith("--") && s2.endsWith("--")) {
            return true;
        }
        if (s2.startsWith("==") && s2.endsWith("==")) {
            return true;
        }
        if (s2.startsWith("..") && s2.endsWith("..") && !s2.equals("...")) {
            return true;
        }
        return s2.startsWith("__") && s2.endsWith("__");
    }

    private TextBlock getTitle(String s2, ISkinSimple spriteContainer) {
        if (s2.length() <= 4) {
            return null;
        }
        s2 = StringUtils.trin(s2.substring(2, s2.length() - 2));
        return Display.getWithNewlines(s2).create(this.titleConfig, HorizontalAlignment.LEFT, spriteContainer);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        TextBlock area = this.getArea(stringBounder);
        if (area instanceof WithPorts) {
            return ((WithPorts)((Object)area)).getPorts(stringBounder);
        }
        return new Ports();
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getArea(ug.getStringBounder()).drawU(ug);
    }

    public List<Url> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.getArea(stringBounder).getInnerPosition(member, stringBounder, strategy);
    }
}

