/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.Guillemet;
import znaishaded.net.sourceforge.plantuml.SpriteContainer;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexComposed;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.svek.PackageStyle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class Stereotype
implements CharSequence {
    private static final RegexComposed circleChar = new RegexConcat(new RegexLeaf("\\<\\<"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(?"), new RegexLeaf("CHAR", "(\\S)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COLOR", "(#[0-9a-fA-F]{6}|\\w+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("LABEL", "[),](.*?)")), new RegexLeaf("\\>\\>"));
    private static final RegexComposed circleSprite = new RegexConcat(new RegexLeaf("\\<\\<"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(?\\$"), new RegexLeaf("NAME", "([-\\p{L}0-9_/]+)"), new RegexLeaf("SCALE", "((?:\\{scale=|\\*)([0-9.]+)\\}?)?"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COLOR", "(#[0-9a-fA-F]{6}|\\w+)"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("LABEL", "[),](.*?)")), new RegexLeaf("\\>\\>"));
    private final double radius;
    private final UFont circledFont;
    private final boolean automaticPackageStyle;
    private String label;
    private HColor htmlColor;
    private char character;
    private String spriteName;
    private double spriteScale;

    public Stereotype(String label, double radius, UFont circledFont, HColorSet htmlColorSet) {
        this(label, radius, circledFont, true, htmlColorSet);
    }

    public Stereotype(String label, boolean automaticPackageStyle) {
        this.automaticPackageStyle = automaticPackageStyle;
        this.label = label;
        this.htmlColor = null;
        this.character = '\u0000';
        this.radius = 0.0;
        this.circledFont = null;
        if (label.startsWith("<<$") && label.endsWith(">>")) {
            RegexResult mCircleSprite = circleSprite.matcher(label);
            this.spriteName = mCircleSprite.get("NAME", 0);
            this.spriteScale = Parser.getScale(mCircleSprite.get("SCALE", 0), 1.0);
        } else {
            this.spriteName = null;
        }
    }

    public Stereotype(String label, double radius, UFont circledFont, boolean automaticPackageStyle, HColorSet htmlColorSet) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        if (!label.startsWith("<<") || !label.endsWith(">>")) {
            throw new IllegalArgumentException(label);
        }
        this.automaticPackageStyle = automaticPackageStyle;
        this.radius = radius;
        this.circledFont = circledFont;
        StringBuilder tmpLabel = new StringBuilder();
        List<String> list = Stereotype.cutLabels(label, Guillemet.DOUBLE_COMPARATOR);
        for (String local : list) {
            String colName;
            RegexResult mCircleChar = circleChar.matcher(local);
            RegexResult mCircleSprite = circleSprite.matcher(local);
            if (mCircleSprite != null) {
                local = StringUtils.isNotEmpty(mCircleSprite.get("LABEL", 0)) ? "<<" + mCircleSprite.get("LABEL", 0) + ">>" : null;
                colName = mCircleSprite.get("COLOR", 0);
                HColor col = htmlColorSet.getColorIfValid(colName);
                this.htmlColor = col == null ? HColorUtils.BLACK : col;
                this.spriteName = mCircleSprite.get("NAME", 0);
                this.character = '\u0000';
                this.spriteScale = Parser.getScale(mCircleSprite.get("SCALE", 0), 1.0);
            } else if (mCircleChar != null) {
                local = StringUtils.isNotEmpty(mCircleChar.get("LABEL", 0)) ? "<<" + mCircleChar.get("LABEL", 0) + ">>" : null;
                colName = mCircleChar.get("COLOR", 0);
                this.htmlColor = htmlColorSet.getColorIfValid(colName);
                this.character = mCircleChar.get("CHAR", 0).charAt(0);
                this.spriteName = null;
            }
            if (local == null) continue;
            tmpLabel.append(local);
        }
        if (tmpLabel.length() > 0) {
            this.label = tmpLabel.toString();
        }
    }

    public Stereotype(String label) {
        this(label, true);
    }

    public HColor getHtmlColor() {
        return this.htmlColor;
    }

    public char getCharacter() {
        return this.character;
    }

    public final TextBlock getSprite(SpriteContainer container) {
        if (this.spriteName == null || container == null) {
            return null;
        }
        Sprite tmp = container.getSprite(this.spriteName);
        if (tmp == null) {
            return null;
        }
        return tmp.asTextBlock(this.getHtmlColor(), this.spriteScale);
    }

    public boolean isWithOOSymbol() {
        return "<<O-O>>".equalsIgnoreCase(this.label);
    }

    public List<String> getMultipleLabels() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.label != null) {
            Pattern p = Pattern.compile("\\<\\<\\s?((?:\\<&\\w+\\>|[^<>])+?)\\s?\\>\\>");
            Matcher m3 = p.matcher(this.label);
            while (m3.find()) {
                result.add(m3.group(1));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isSpotted() {
        return this.character != '\u0000';
    }

    @Override
    public String toString() {
        if (this.label == null) {
            return "" + this.character;
        }
        if (this.character == '\u0000') {
            return this.label;
        }
        return this.character + " " + this.label;
    }

    @Override
    public char charAt(int arg0) {
        return this.toString().charAt(arg0);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int arg0, int arg1) {
        return this.toString().subSequence(arg0, arg1);
    }

    public double getRadius() {
        return this.radius;
    }

    public final UFont getCircledFont() {
        return this.circledFont;
    }

    public String getLabel(Guillemet guillemet) {
        assert (this.label == null || this.label.length() > 0);
        if (this.isWithOOSymbol()) {
            return null;
        }
        if (this.spriteName != null && this.spriteName.startsWith("archimate/")) {
            return guillemet.manageGuillemet("<<" + this.spriteName.substring("archimate/".length()) + ">>");
        }
        return guillemet.manageGuillemet(this.label);
    }

    public List<String> getLabels(Guillemet guillemet) {
        String labelLocal = this.getLabel(Guillemet.DOUBLE_COMPARATOR);
        if (labelLocal == null) {
            return Collections.emptyList();
        }
        return Stereotype.cutLabels(labelLocal, guillemet);
    }

    public List<Style> getStyles(StyleBuilder builder) {
        ArrayList<Style> result = new ArrayList<Style>();
        for (String s2 : this.getStyleNames()) {
            Style style = builder.createStyle(s2);
            assert (style != null);
            result.add(style);
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> getStyleNames() {
        List<String> labels = this.getLabels(Guillemet.NONE);
        if (labels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(labels);
    }

    private static List<String> cutLabels(String label, Guillemet guillemet) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern2 p = MyPattern.cmpile("\\<\\<.*?\\>\\>");
        Matcher2 m3 = p.matcher(label);
        while (m3.find()) {
            result.add(guillemet.manageGuillemetStrict(m3.group()));
        }
        return Collections.unmodifiableList(result);
    }

    public PackageStyle getPackageStyle() {
        if (!this.automaticPackageStyle) {
            return null;
        }
        for (PackageStyle p : EnumSet.allOf(PackageStyle.class)) {
            if (!("<<" + (Object)((Object)p) + ">>").equalsIgnoreCase(this.label)) continue;
            return p;
        }
        return null;
    }

    public boolean isBiddableOrUncertain() {
        return this.label.equalsIgnoreCase("<<B>>") || this.label.equalsIgnoreCase("<<Biddable>>") || this.label.equalsIgnoreCase("<<Uncertain>>");
    }

    public boolean isCausal() {
        return this.label.equalsIgnoreCase("<<C>>") || this.label.equalsIgnoreCase("<<Causal>>");
    }

    public boolean isLexicalOrGiven() {
        return this.label.equalsIgnoreCase("<<L>>") || this.label.equalsIgnoreCase("<<Lexical>>") || this.label.equalsIgnoreCase("<<X>>") || this.label.equalsIgnoreCase("<<Given>>");
    }

    public boolean isDesignedOrSolved() {
        return this.label.equalsIgnoreCase("<<D>>") || this.label.equalsIgnoreCase("<<Designed>>") || this.label.equalsIgnoreCase("<<Nested>>") || this.label.equalsIgnoreCase("<<Solved>>");
    }

    public boolean isMachineOrSpecification() {
        return this.label.equalsIgnoreCase("M") || this.label.equalsIgnoreCase("<<Machine>>") || this.label.equalsIgnoreCase("<<S>>") || this.label.equalsIgnoreCase("<<Spec>>") || this.label.equalsIgnoreCase("<<Specification>>");
    }
}

