/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.cute.Positionned;
import znaishaded.net.sourceforge.plantuml.cute.RotationZoom;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class Group
implements Positionned {
    private final String groupName;
    private final List<Positionned> shapes;
    private final Group parent;
    private final Map<String, Group> children;

    public String toString() {
        return "Group " + this.groupName + " (" + this.shapes.size() + ") ";
    }

    public static Group createRoot() {
        return new Group(null, "ROOT");
    }

    private Group(Group parent, String groupName) {
        this.parent = parent;
        this.groupName = groupName;
        this.shapes = new ArrayList<Positionned>();
        this.children = new HashMap<String, Group>();
    }

    private Group(Group parent, String groupName, List<Positionned> shapes) {
        this.parent = parent;
        this.groupName = groupName;
        this.shapes = shapes;
        this.children = null;
    }

    public Group createChild(String childName) {
        Group result = new Group(this, childName);
        this.children.put(childName, result);
        return result;
    }

    @Override
    public void drawU(UGraphic ug) {
        for (Positionned shape : this.shapes) {
            shape.drawU(ug);
        }
    }

    public void add(Positionned shape) {
        this.shapes.add(shape);
    }

    public String getName() {
        return this.groupName;
    }

    @Override
    public Positionned rotateZoom(RotationZoom rotationZoom) {
        if (rotationZoom.isNone()) {
            return this;
        }
        ArrayList<Positionned> result = new ArrayList<Positionned>();
        for (Positionned shape : this.shapes) {
            result.add(shape.rotateZoom(rotationZoom));
        }
        return new Group(this.parent, this.groupName + "->" + rotationZoom, result);
    }

    @Override
    public Positionned translate(UTranslate translation) {
        throw new UnsupportedOperationException();
    }

    public Group getParent() {
        return this.parent;
    }

    public Map<String, Group> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }
}

