/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class Segment {
    private final Point2D a;
    private final Point2D b;
    private final double length;

    public Segment(Point2D a, Point2D b) {
        this.a = a;
        this.b = b;
        this.length = a.distance(b);
        if (this.length < 1.0E-4) {
            throw new IllegalArgumentException();
        }
    }

    public Point2D getFromAtoB(double dist) {
        double dx = this.b.getX() - this.a.getX();
        double dy = this.b.getY() - this.a.getY();
        double coef = dist / this.length;
        double x = dx * coef;
        double y = dy * coef;
        return new Point2D.Double(this.a.getX() + x, this.a.getY() + y);
    }

    public Point2D getA() {
        return this.a;
    }

    public Point2D getB() {
        return this.b;
    }

    public Point2D getMiddle() {
        return new Point2D.Double((this.a.getX() + this.b.getX()) / 2.0, (this.a.getY() + this.b.getY()) / 2.0);
    }

    private Point2D orthoDirection() {
        double dx = this.b.getX() - this.a.getX();
        double dy = this.b.getY() - this.a.getY();
        return new Point2D.Double(-dy / this.length, dx / this.length);
    }

    public Point2D getOrthoPoint(double value) {
        Point2D ortho = this.orthoDirection();
        double dx = -ortho.getX() * value;
        double dy = -ortho.getY() * value;
        return new Point2D.Double((this.a.getX() + this.b.getX()) / 2.0 + dx, (this.a.getY() + this.b.getY()) / 2.0 + dy);
    }

    private boolean isLeft(Point2D point) {
        return (this.b.getX() - this.a.getX()) * (point.getY() - this.a.getY()) - (this.b.getY() - this.a.getY()) * (point.getX() - this.a.getX()) > 0.0;
    }

    public double getLength() {
        return this.length;
    }

    public void debugMe(UGraphic ug) {
        double dx = this.b.getX() - this.a.getX();
        double dy = this.b.getY() - this.a.getY();
        ug = ug.apply(new UTranslate(this.a));
        ug.draw(new ULine(dx, dy));
    }
}

