/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.golem;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.golem.TileArea;
import znaishaded.net.sourceforge.plantuml.golem.TileGeometry;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class Tile
extends AbstractTextBlock
implements TextBlock {
    private static double SIZE = 40.0;
    private final int num;
    private final UFont numberFont = UFont.monospaced(11);
    private final FontConfiguration fc = FontConfiguration.blackBlueTrue(this.numberFont);
    private final Map<TileGeometry, TileArea> geometries;

    Tile(int num) {
        this.num = num;
        EnumMap<TileGeometry, TileArea> tmp = new EnumMap<TileGeometry, TileArea>(TileGeometry.class);
        for (TileGeometry g2 : TileGeometry.values()) {
            tmp.put(g2, new TileArea(this, g2));
        }
        this.geometries = Collections.unmodifiableMap(tmp);
    }

    public TileArea getArea(TileGeometry geometry) {
        return this.geometries.get((Object)geometry);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(HColorUtils.BLACK);
        TextBlock n = Display.create("" + this.num).create(this.fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        Dimension2D dimNum = n.calculateDimension(ug.getStringBounder());
        Dimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        double diffx = dimTotal.getWidth() - dimNum.getWidth();
        double diffy = dimTotal.getHeight() - dimNum.getHeight();
        double radius = Math.max(dimNum.getWidth(), dimNum.getHeight());
        double diffx2 = dimTotal.getWidth() - radius;
        double diffy2 = dimTotal.getHeight() - radius;
        n.drawU(ug.apply(new UTranslate(diffx / 2.0, diffy / 2.0)));
        ug.draw(new URectangle(SIZE, SIZE));
        ug.apply(new UTranslate(diffx2 / 2.0, diffy2 / 2.0)).draw(new UEllipse(radius, radius));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(SIZE, SIZE);
    }
}

