/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.ComponentStyle;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.SkinParameter;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolActor;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolArtifact;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolBoundary;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolCard;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolCloud;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolCollections;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolComponent1;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolComponent2;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolControl;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolDatabase;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolEntityDomain;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolFile;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolFolder;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolFrame;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolInterface;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolLabel;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolNode;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolQueue;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolRect;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolStack;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolStorage;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolTogether;
import znaishaded.net.sourceforge.plantuml.skin.ActorStyle;
import znaishaded.net.sourceforge.plantuml.svek.PackageStyle;

public abstract class USymbol {
    private static final Map<String, USymbol> all = new HashMap<String, USymbol>();
    public static final USymbol STORAGE = USymbol.record("STORAGE", SkinParameter.STORAGE, new USymbolStorage());
    public static final USymbol DATABASE = USymbol.record("DATABASE", SkinParameter.DATABASE, new USymbolDatabase());
    public static final USymbol CLOUD = USymbol.record("CLOUD", SkinParameter.CLOUD, new USymbolCloud());
    public static final USymbol CARD = USymbol.record("CARD", SkinParameter.CARD, new USymbolCard(SkinParameter.CARD));
    public static final USymbol FRAME = USymbol.record("FRAME", SkinParameter.FRAME, new USymbolFrame());
    public static final USymbol NODE = USymbol.record("NODE", SkinParameter.NODE, new USymbolNode());
    public static final USymbol ARTIFACT = USymbol.record("ARTIFACT", SkinParameter.ARTIFACT, new USymbolArtifact());
    public static final USymbol PACKAGE = USymbol.record("PACKAGE", SkinParameter.PACKAGE, new USymbolFolder(SkinParameter.PACKAGE, true));
    public static final USymbol FOLDER = USymbol.record("FOLDER", SkinParameter.FOLDER, new USymbolFolder(SkinParameter.FOLDER, false));
    public static final USymbol FILE = USymbol.record("FILE", SkinParameter.FILE, new USymbolFile());
    public static final USymbol RECTANGLE = USymbol.record("RECTANGLE", SkinParameter.RECTANGLE, new USymbolRect(SkinParameter.RECTANGLE));
    public static final USymbol LABEL = USymbol.record("LABEL", SkinParameter.RECTANGLE, new USymbolLabel(SkinParameter.RECTANGLE));
    public static final USymbol ARCHIMATE = USymbol.record("ARCHIMATE", SkinParameter.ARCHIMATE, new USymbolRect(SkinParameter.ARCHIMATE));
    public static final USymbol COLLECTIONS = USymbol.record("COLLECTIONS", SkinParameter.COLLECTIONS, new USymbolCollections(SkinParameter.RECTANGLE));
    public static final USymbol AGENT = USymbol.record("AGENT", SkinParameter.AGENT, new USymbolRect(SkinParameter.AGENT));
    public static final USymbol ACTOR_STICKMAN = USymbol.record("ACTOR_STICKMAN", SkinParameter.ACTOR, new USymbolActor(ActorStyle.STICKMAN));
    public static final USymbol ACTOR_AWESOME = USymbol.record("ACTOR_AWESOME", SkinParameter.ACTOR, new USymbolActor(ActorStyle.AWESOME));
    public static final USymbol USECASE = null;
    public static final USymbol COMPONENT1 = USymbol.record("COMPONENT1", SkinParameter.COMPONENT1, new USymbolComponent1());
    public static final USymbol COMPONENT2 = USymbol.record("COMPONENT2", SkinParameter.COMPONENT2, new USymbolComponent2());
    public static final USymbol BOUNDARY = USymbol.record("BOUNDARY", SkinParameter.BOUNDARY, new USymbolBoundary());
    public static final USymbol ENTITY_DOMAIN = USymbol.record("ENTITY_DOMAIN", SkinParameter.ENTITY, new USymbolEntityDomain(2.0));
    public static final USymbol CONTROL = USymbol.record("CONTROL", SkinParameter.CONTROL, new USymbolControl(2.0));
    public static final USymbol INTERFACE = USymbol.record("INTERFACE", SkinParameter.INTERFACE, new USymbolInterface());
    public static final USymbol QUEUE = USymbol.record("QUEUE", SkinParameter.QUEUE, new USymbolQueue());
    public static final USymbol STACK = USymbol.record("STACK", SkinParameter.STACK, new USymbolStack());
    public static final USymbol TOGETHER = USymbol.record("TOGETHER", SkinParameter.QUEUE, new USymbolTogether());

    public abstract SkinParameter getSkinParameter();

    public FontParam getFontParam() {
        return this.getSkinParameter().getFontParam();
    }

    public FontParam getFontParamStereotype() {
        return this.getSkinParameter().getFontParamStereotype();
    }

    public ColorParam getColorParamBack() {
        return this.getSkinParameter().getColorParamBack();
    }

    public ColorParam getColorParamBorder() {
        return this.getSkinParameter().getColorParamBorder();
    }

    private static USymbol record(String code, SkinParameter skinParameter, USymbol symbol) {
        all.put(StringUtils.goUpperCase(code), symbol);
        return symbol;
    }

    public abstract TextBlock asSmall(TextBlock var1, TextBlock var2, TextBlock var3, SymbolContext var4, HorizontalAlignment var5);

    public abstract TextBlock asBig(TextBlock var1, HorizontalAlignment var2, TextBlock var3, double var4, double var6, SymbolContext var8, HorizontalAlignment var9);

    public boolean manageHorizontalLine() {
        return false;
    }

    public int suppHeightBecauseOfShape() {
        return 0;
    }

    public int suppWidthBecauseOfShape() {
        return 0;
    }

    final Stencil getRectangleStencil(final Dimension2D dim) {
        return new Stencil(){

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                return 0.0;
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                return dim.getWidth();
            }
        };
    }

    public static USymbol fromString(String s2, ActorStyle actorStyle, ComponentStyle componentStyle, PackageStyle packageStyle) {
        if (s2 == null) {
            return null;
        }
        if (s2.equalsIgnoreCase("package")) {
            return packageStyle.toUSymbol();
        }
        if (s2.equalsIgnoreCase("actor")) {
            return actorStyle.toUSymbol();
        }
        if (s2.equalsIgnoreCase("component")) {
            return componentStyle.toUSymbol();
        }
        if (s2.equalsIgnoreCase("entity")) {
            return ENTITY_DOMAIN;
        }
        USymbol result = all.get(StringUtils.goUpperCase(s2.replaceAll("\\W", "")));
        return result;
    }

    public static USymbol fromString(String symbol, ISkinParam skinParam) {
        USymbol usymbol = null;
        if (symbol.equalsIgnoreCase("artifact")) {
            usymbol = ARTIFACT;
        } else if (symbol.equalsIgnoreCase("folder")) {
            usymbol = FOLDER;
        } else if (symbol.equalsIgnoreCase("file")) {
            usymbol = FILE;
        } else if (symbol.equalsIgnoreCase("package")) {
            usymbol = PACKAGE;
        } else if (symbol.equalsIgnoreCase("rectangle")) {
            usymbol = RECTANGLE;
        } else if (symbol.equalsIgnoreCase("label")) {
            usymbol = LABEL;
        } else if (symbol.equalsIgnoreCase("collections")) {
            usymbol = COLLECTIONS;
        } else if (symbol.equalsIgnoreCase("node")) {
            usymbol = NODE;
        } else if (symbol.equalsIgnoreCase("frame")) {
            usymbol = FRAME;
        } else if (symbol.equalsIgnoreCase("cloud")) {
            usymbol = CLOUD;
        } else if (symbol.equalsIgnoreCase("database")) {
            usymbol = DATABASE;
        } else if (symbol.equalsIgnoreCase("queue")) {
            usymbol = QUEUE;
        } else if (symbol.equalsIgnoreCase("stack")) {
            usymbol = STACK;
        } else if (symbol.equalsIgnoreCase("storage")) {
            usymbol = STORAGE;
        } else if (symbol.equalsIgnoreCase("agent")) {
            usymbol = AGENT;
        } else if (symbol.equalsIgnoreCase("actor")) {
            usymbol = skinParam.actorStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("component")) {
            usymbol = skinParam.componentStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("boundary")) {
            usymbol = BOUNDARY;
        } else if (symbol.equalsIgnoreCase("control")) {
            usymbol = CONTROL;
        } else if (symbol.equalsIgnoreCase("entity")) {
            usymbol = ENTITY_DOMAIN;
        } else if (symbol.equalsIgnoreCase("card")) {
            usymbol = CARD;
        } else if (symbol.equalsIgnoreCase("interface")) {
            usymbol = INTERFACE;
        } else if (symbol.equalsIgnoreCase("()")) {
            usymbol = INTERFACE;
        }
        return usymbol;
    }

    static class Margin {
        private final double x1;
        private final double x2;
        private final double y1;
        private final double y2;

        Margin(double x1, double x2, double y1, double y2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
        }

        double getWidth() {
            return this.x1 + this.x2;
        }

        double getHeight() {
            return this.y1 + this.y2;
        }

        public Dimension2D addDimension(Dimension2D dim) {
            return new Dimension2DDouble(dim.getWidth() + this.x1 + this.x2, dim.getHeight() + this.y1 + this.y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }
    }
}

