/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import znaishaded.net.sourceforge.plantuml.hector.Pin;

public class PinLink {
    private final Pin pin1;
    private final Pin pin2;
    private final Object userData;
    private final int length;

    public PinLink(Pin pin1, Pin pin2, int length, Object userData) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        this.pin1 = pin1;
        this.pin2 = pin2;
        this.userData = userData;
        this.length = length;
    }

    public boolean contains(Pin pin) {
        return pin == this.pin1 || pin == this.pin2;
    }

    public boolean doesTouch(PinLink other) {
        return other.contains(this.pin1) || other.contains(this.pin2);
    }

    public Pin getPin1() {
        return this.pin1;
    }

    public Pin getPin2() {
        return this.pin2;
    }

    public int getLengthDot() {
        return this.length;
    }

    public int getLengthStandard() {
        return this.length - 1;
    }
}

