/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import znaishaded.net.sourceforge.plantuml.posimo.Positionable;

public class BezierUtils {
    public static double getEndingAngle(CubicCurve2D.Double left) {
        if (left.getCtrlP2().equals(left.getP2())) {
            return BezierUtils.getAngle(left.getP1(), left.getP2());
        }
        return BezierUtils.getAngle(left.getCtrlP2(), left.getP2());
    }

    public static double getStartingAngle(CubicCurve2D.Double left) {
        if (left.getP1().equals(left.getCtrlP1())) {
            return BezierUtils.getAngle(left.getP1(), left.getP2());
        }
        return BezierUtils.getAngle(left.getP1(), left.getCtrlP1());
    }

    static double getAngle(Point2D p1, Point2D p2) {
        if (p1.equals(p2)) {
            throw new IllegalArgumentException();
        }
        return Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX());
    }

    static boolean isCutting(CubicCurve2D.Double bez, Shape shape) {
        boolean contains1 = shape.contains(bez.x1, bez.y1);
        boolean contains2 = shape.contains(bez.x2, bez.y2);
        return contains1 ^ contains2;
    }

    static void shorten(CubicCurve2D.Double bez, Shape shape) {
        boolean contains2;
        boolean contains1 = shape.contains(bez.x1, bez.y1);
        if (contains1 ^ !(contains2 = shape.contains(bez.x2, bez.y2))) {
            throw new IllegalArgumentException();
        }
        if (!contains1) {
            bez.setCurve(bez.x2, bez.y2, bez.ctrlx2, bez.ctrly2, bez.ctrlx1, bez.ctrly1, bez.x1, bez.y1);
        }
        assert (shape.contains(bez.x1, bez.y1) && !shape.contains(bez.x2, bez.y2));
        CubicCurve2D.Double left = new CubicCurve2D.Double();
        CubicCurve2D.Double right = new CubicCurve2D.Double();
        BezierUtils.subdivide(bez, left, right, 0.5);
        if (BezierUtils.isCutting(left, shape) ^ !BezierUtils.isCutting(right, shape)) {
            throw new IllegalArgumentException();
        }
        if (BezierUtils.isCutting(left, shape)) {
            bez.setCurve(left);
        } else {
            bez.setCurve(right);
        }
    }

    private static void subdivide(CubicCurve2D src, CubicCurve2D left, CubicCurve2D right, double coef) {
        double coef1 = coef;
        double coef2 = 1.0 - coef;
        double centerxA = src.getCtrlX1() * coef1 + src.getCtrlX2() * coef2;
        double centeryA = src.getCtrlY1() * coef1 + src.getCtrlY2() * coef2;
        double x1 = src.getX1();
        double y1 = src.getY1();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double ctrlx1 = x1 * coef1 + src.getCtrlX1() * coef1;
        double ctrly1 = y1 * coef1 + src.getCtrlY1() * coef1;
        double ctrlx2 = x2 * coef1 + src.getCtrlX2() * coef1;
        double ctrly2 = y2 * coef1 + src.getCtrlY2() * coef1;
        double ctrlx12 = ctrlx1 * coef1 + centerxA * coef1;
        double ctrly12 = ctrly1 * coef1 + centeryA * coef1;
        double ctrlx21 = ctrlx2 * coef1 + centerxA * coef1;
        double ctrly21 = ctrly2 * coef1 + centeryA * coef1;
        double centerxB = ctrlx12 * coef1 + ctrlx21 * coef1;
        double centeryB = ctrly12 * coef1 + ctrly21 * coef1;
        left.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx12, ctrly12, centerxB, centeryB);
        right.setCurve(centerxB, centeryB, ctrlx21, ctrly21, ctrlx2, ctrly2, x2, y2);
    }

    static double dist(CubicCurve2D.Double seg) {
        return Point2D.distance(seg.x1, seg.y1, seg.x2, seg.y2);
    }

    static double dist(Line2D.Double seg) {
        return Point2D.distance(seg.x1, seg.y1, seg.x2, seg.y2);
    }

    public static Point2D middle(Line2D.Double seg) {
        return new Point2D.Double((seg.x1 + seg.x2) / 2.0, (seg.y1 + seg.y2) / 2.0);
    }

    public static Point2D middle(Point2D p1, Point2D p2) {
        return new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
    }

    public static Point2D intersect(Line2D.Double orig, Shape shape) {
        boolean contains2;
        Line2D.Double copy = new Line2D.Double(orig.x1, orig.y1, orig.x2, orig.y2);
        boolean contains1 = shape.contains(copy.x1, copy.y1);
        if (contains1 ^ !(contains2 = shape.contains(copy.x2, copy.y2))) {
            throw new IllegalArgumentException();
        }
        do {
            double my;
            double mx;
            boolean containsMiddle;
            if (contains1 == (containsMiddle = shape.contains(mx = (copy.x1 + copy.x2) / 2.0, my = (copy.y1 + copy.y2) / 2.0))) {
                copy.x1 = mx;
                copy.y1 = my;
                continue;
            }
            copy.x2 = mx;
            copy.y2 = my;
        } while (!(BezierUtils.dist(copy) < 0.1));
        if (contains1) {
            return new Point2D.Double(copy.x2, copy.y2);
        }
        if (contains2) {
            return new Point2D.Double(copy.x1, copy.y1);
        }
        throw new IllegalStateException();
    }

    public static Rectangle2D toRectangle(Positionable p) {
        Point2D point = p.getPosition();
        Dimension2D dim = p.getSize();
        return new Rectangle2D.Double(point.getX(), point.getY(), dim.getWidth(), dim.getHeight());
    }

    public static boolean intersect(Positionable p1, Positionable p2) {
        return BezierUtils.toRectangle(p1).intersects(BezierUtils.toRectangle(p2));
    }

    public static Point2D.Double getCenter(Positionable p) {
        return new Point2D.Double(BezierUtils.toRectangle(p).getCenterX(), BezierUtils.toRectangle(p).getCenterY());
    }
}

