/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.core;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.project.LoadPlanable;
import znaishaded.net.sourceforge.plantuml.project.draw.ResourceDraw;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.time.GCalendar;
import znaishaded.net.sourceforge.plantuml.project.time.Wink;

public class Resource {
    private final String name;
    private ResourceDraw draw;
    private final Set<Wink> closed = new TreeSet<Wink>();
    private final Set<Wink> forcedOn = new TreeSet<Wink>();
    private final GCalendar calendar;
    private final Collection<DayOfWeek> closedDayOfWeek = EnumSet.noneOf(DayOfWeek.class);

    public Resource(String name, LoadPlanable loadPlanable, GCalendar calendar) {
        this.name = name;
        this.calendar = calendar;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        Resource other = (Resource)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceDraw getResourceDraw() {
        return this.draw;
    }

    public void setTaskDraw(ResourceDraw draw) {
        this.draw = draw;
    }

    public boolean isClosedAt(Wink instant) {
        Day d;
        if (this.forcedOn.contains(instant)) {
            return false;
        }
        if (this.closedDayOfWeek.size() > 0 && this.calendar != null && this.closedDayOfWeek.contains((Object)(d = this.calendar.toDayAsDate(instant)).getDayOfWeek())) {
            return true;
        }
        return this.closed.contains(instant);
    }

    public void addCloseDay(Wink instant) {
        this.closed.add(instant);
    }

    public void addForceOnDay(Wink instant) {
        this.forcedOn.add(instant);
    }

    public void addCloseDay(DayOfWeek dayOfWeek) {
        this.closedDayOfWeek.add(dayOfWeek);
    }
}

