/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.draw;

import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.project.ToTaskDraw;
import znaishaded.net.sourceforge.plantuml.project.core.Task;
import znaishaded.net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import znaishaded.net.sourceforge.plantuml.project.time.Wink;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class TaskDrawDiamond
extends AbstractTaskDraw {
    public TaskDrawDiamond(TimeScale timeScale, double y, String prettyDisplay, Wink start, ISkinParam skinParam, Task task, ToTaskDraw toTaskDraw) {
        super(timeScale, y, prettyDisplay, start, skinParam, task, toTaskDraw);
    }

    @Override
    protected Style getStyle() {
        Style style = StyleSignature.of(SName.root, SName.element, SName.ganttDiagram, SName.milestone).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style;
    }

    @Override
    public final void drawTitle(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        double titleHeight = title.calculateDimension(ug.getStringBounder()).getHeight();
        double h2 = (2.0 + this.getShapeHeight() - titleHeight) / 2.0;
        double endingPosition = this.timeScale.getStartingPosition(this.start) + this.getHeight();
        title.drawU(ug.apply(new UTranslate(endingPosition, h2)));
    }

    @Override
    public void drawU(UGraphic ug1) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        ug1 = this.applyColors(ug1);
        UGraphic ug2 = ug1.apply(new UTranslate(startPos + 2.0, 2.0));
        this.drawShape(ug2);
    }

    private UGraphic applyColors(UGraphic ug) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(ug);
        }
        return ug.apply(this.getLineColor()).apply(this.getBackgroundColor().bg());
    }

    private void drawShape(UGraphic ug) {
        ug.draw(this.getDiamond());
    }

    private UShape getDiamond() {
        double h2 = this.getHeight() - 4.0;
        UPolygon result = new UPolygon();
        result.addPoint(h2 / 2.0, 0.0);
        result.addPoint(h2, h2 / 2.0);
        result.addPoint(h2 / 2.0, h2);
        result.addPoint(0.0, h2 / 2.0);
        return result;
    }
}

