/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.draw;

import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeader;
import znaishaded.net.sourceforge.plantuml.project.time.Wink;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScaleWink;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TimeHeaderSimple
extends TimeHeader {
    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight() + this.getHeaderNameDayHeight();
    }

    private double getTimeHeaderHeight() {
        return 16.0;
    }

    private double getHeaderNameDayHeight() {
        return 0.0;
    }

    public TimeHeaderSimple(Wink min2, Wink max) {
        super(min2, max, new TimeScaleWink());
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeight) {
        double xmin = this.getTimeScale().getStartingPosition(this.min);
        double xmax = this.getTimeScale().getEndingPosition(this.max);
        this.drawSimpleDayCounter(ug, this.getTimeScale(), totalHeight);
        ug.apply(HColorUtils.LIGHT_GRAY).draw(ULine.hline(xmax - xmin));
        ug.apply(HColorUtils.LIGHT_GRAY).apply(UTranslate.dy(this.getFullHeaderHeight() - 3.0)).draw(ULine.hline(xmax - xmin));
    }

    private void drawSimpleDayCounter(UGraphic ug, TimeScale timeScale, double totalHeight) {
        ULine vbar = ULine.vline(totalHeight);
        Wink i = this.min;
        while (i.compareTo(this.max.increment()) <= 0) {
            TextBlock num = Display.getWithNewlines(i.toShortString()).create(this.getFontConfiguration(10, false, HColorUtils.BLACK), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = timeScale.getStartingPosition(i);
            double x2 = timeScale.getEndingPosition(i);
            double width = num.calculateDimension(ug.getStringBounder()).getWidth();
            double delta = x2 - x1 - width;
            if (i.compareTo(this.max.increment()) < 0) {
                num.drawU(ug.apply(UTranslate.dx(x1 + delta / 2.0)));
            }
            ug.apply(HColorUtils.LIGHT_GRAY).apply(UTranslate.dx(x1)).draw(vbar);
            i = i.increment();
        }
    }
}

