/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.SpecificBackcolorable;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteStyle;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.style.WithStyle;

public final class Note
extends AbstractEvent
implements Event,
SpecificBackcolorable,
WithStyle {
    private final Participant p;
    private final Participant p2;
    private final Display strings;
    private NotePosition position;
    private final StyleBuilder styleBuilder;
    private NoteStyle noteStyle = NoteStyle.NORMAL;
    private Colors colors = Colors.empty();
    private Url url;
    private Style style;
    private boolean parallel = false;

    public void temporaryProtectedUntilTeozIsStandard() {
        if (this.position == NotePosition.BOTTOM || this.position == NotePosition.TOP) {
            this.position = NotePosition.LEFT;
        }
    }

    @Override
    public StyleSignature getDefaultStyleDefinition() {
        return this.noteStyle.getDefaultStyleDefinition();
    }

    @Override
    public Style[] getUsedStyles() {
        if (this.style != null) {
            return new Style[]{this.style.eventuallyOverride(this.colors)};
        }
        return new Style[]{this.style};
    }

    public Note(Participant p, NotePosition position, Display strings, StyleBuilder styleBuilder) {
        this(p, null, position, strings, styleBuilder);
    }

    public Note(Display strings, NotePosition position, NoteStyle style, StyleBuilder styleBuilder) {
        this(null, null, position, strings, styleBuilder);
        this.noteStyle = style;
    }

    public Note(Participant p, Participant p2, Display strings, StyleBuilder styleBuilder) {
        this(p, p2, NotePosition.OVER_SEVERAL, strings, styleBuilder);
    }

    private Note(Participant p, Participant p2, NotePosition position, Display strings, StyleBuilder styleBuilder) {
        this.p = p;
        this.p2 = p2;
        this.styleBuilder = styleBuilder;
        this.position = position;
        this.strings = strings;
        if (SkinParam.USE_STYLES()) {
            this.style = this.getDefaultStyleDefinition().getMergedStyle(styleBuilder);
        }
    }

    public void setStereotype(Stereotype stereotype) {
        if (SkinParam.USE_STYLES()) {
            List<Style> others = stereotype.getStyles(this.styleBuilder);
            this.style = this.getDefaultStyleDefinition().mergeWith(others).getMergedStyle(this.styleBuilder);
        }
    }

    public Note withPosition(NotePosition newPosition) {
        if (this.position == newPosition) {
            return this;
        }
        Note result = new Note(this.p, this.p2, newPosition, this.strings, this.styleBuilder);
        result.noteStyle = this.noteStyle;
        result.url = this.url;
        result.colors = this.colors;
        result.parallel = this.parallel;
        return result;
    }

    public Participant getParticipant() {
        return this.p;
    }

    public Participant getParticipant2() {
        return this.p2;
    }

    public Display getStrings() {
        return this.strings;
    }

    public NotePosition getPosition() {
        return this.position;
    }

    @Override
    public final Colors getColors(ISkinParam skinParam) {
        return this.colors;
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.p == someone || this.p2 == someone;
    }

    @Override
    public Url getUrl() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    public final NoteStyle getNoteStyle() {
        return this.noteStyle;
    }

    public final void setNoteStyle(NoteStyle style) {
        this.noteStyle = style;
    }

    public ISkinParam getSkinParamBackcolored(ISkinParam skinParam) {
        return this.colors.mute(skinParam);
    }

    public String toString() {
        return super.toString() + " " + this.strings;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    public void goParallel() {
        this.parallel = true;
    }

    @Override
    public boolean isParallel() {
        return this.parallel;
    }
}

