/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class YPositionedTile {
    private final Tile tile;
    private final double y;

    public boolean inArea(double ymin, double ymax) {
        return this.y >= ymin && this.y < ymax;
    }

    public YPositionedTile(Tile tile, double y) {
        this.tile = tile;
        this.y = y;
        if (tile instanceof TileWithCallbackY) {
            ((TileWithCallbackY)tile).callbackY(y);
        }
    }

    public String toString() {
        return "y=" + this.y + " " + this.tile;
    }

    public void drawInArea(UGraphic ug) {
        ug.apply(UTranslate.dy(this.y)).draw(this.tile);
    }

    public boolean matchAnchorV2(String anchor) {
        boolean result = this.tile.matchAnchorV1(anchor);
        return result;
    }

    public final double getY(StringBounder stringBounder) {
        TileWithUpdateStairs communicationTile = (TileWithUpdateStairs)this.tile;
        return this.y + communicationTile.getYPoint(stringBounder);
    }

    public double getMiddleX(StringBounder stringBounder) {
        double max = this.tile.getMaxX(stringBounder).getCurrentValue();
        double min2 = this.tile.getMinX(stringBounder).getCurrentValue();
        return (min2 + max) / 2.0;
    }
}

