/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.ArrowDecoration;
import znaishaded.net.sourceforge.plantuml.skin.ArrowHead;
import znaishaded.net.sourceforge.plantuml.skin.ArrowPart;
import znaishaded.net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class ComponentRoseSelfArrow
extends AbstractComponentRoseArrow {
    private final double arrowWidth = 45.0;
    private final boolean niceArrow;

    public ComponentRoseSelfArrow(Style style, HColor foregroundColor, FontConfiguration font, Display stringsToDisplay, ArrowConfiguration arrowConfiguration, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, boolean niceArrow) {
        super(style, foregroundColor, font, stringsToDisplay, arrowConfiguration, spriteContainer, HorizontalAlignment.LEFT, maxMessageSize);
        this.niceArrow = niceArrow;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        boolean hasFinalCrossX;
        if (this.getArrowConfiguration().isHidden()) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        double textHeight = this.getTextHeight(stringBounder);
        ug = ug.apply(this.getForegroundColor());
        double xRight = 42.0;
        UGraphic ug2 = this.getArrowConfiguration().applyStroke(ug);
        double x1 = area.getDeltaX1() < 0.0 ? area.getDeltaX1() : 0.0;
        double x2 = area.getDeltaX1() > 0.0 ? -area.getDeltaX1() : 1.0;
        double textAndArrowHeight = textHeight + this.getArrowOnlyHeight(stringBounder);
        UEllipse circle = new UEllipse(8.0, 8.0);
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE) {
            ug2.apply(new UStroke(1.5)).apply(this.getForegroundColor()).apply(new UTranslate(x1 + 1.0 - 4.0 - 1.5, textHeight - 4.0 - 0.75)).draw(circle);
            x1 += 4.0;
        }
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE) {
            ug2.apply(new UStroke(1.5)).apply(this.getForegroundColor()).apply(new UTranslate(x2 - 4.0 - 1.5, textAndArrowHeight - 4.0 - 0.75)).draw(circle);
            x2 += 4.0;
        }
        boolean bl = hasFinalCrossX = this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.CROSSX;
        if (hasFinalCrossX) {
            x2 += 12.0;
        }
        double arrowHeight = textAndArrowHeight - textHeight;
        ug2.apply(new UTranslate(x1, textHeight)).draw(ULine.hline(42.0 - x1));
        ug2.apply(new UTranslate(42.0, textHeight)).draw(ULine.vline(arrowHeight));
        ug2.apply(new UTranslate(x2, textAndArrowHeight)).draw(ULine.hline(42.0 - x2));
        if (this.getArrowConfiguration().isAsync()) {
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x2, textAndArrowHeight)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x2, textAndArrowHeight)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (hasFinalCrossX) {
            ug = ug.apply(new UStroke(2.0));
            ug.apply(new UTranslate(6.0, textHeight - (double)(this.getArrowDeltaX() / 2) + this.getArrowOnlyHeight(stringBounder))).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(new UTranslate(6.0, textHeight + (double)(this.getArrowDeltaX() / 2) + this.getArrowOnlyHeight(stringBounder))).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else {
            UPolygon polygon = this.getPolygon(textAndArrowHeight);
            ug.apply(this.getForegroundColor().bg()).apply(UTranslate.dx(x2)).draw(polygon);
        }
        this.getTextBlock().drawU(ug.apply(UTranslate.dx(this.getMarginX1())));
    }

    private UPolygon getPolygon(double textAndArrowHeight) {
        UPolygon polygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            polygon.addPoint(this.getArrowDeltaX(), textAndArrowHeight - (double)this.getArrowDeltaY());
            polygon.addPoint(0.0, textAndArrowHeight);
            polygon.addPoint(this.getArrowDeltaX(), textAndArrowHeight);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(this.getArrowDeltaX(), textAndArrowHeight);
            polygon.addPoint(0.0, textAndArrowHeight);
            polygon.addPoint(this.getArrowDeltaX(), textAndArrowHeight + (double)this.getArrowDeltaY());
        } else {
            polygon.addPoint(this.getArrowDeltaX(), textAndArrowHeight - (double)this.getArrowDeltaY());
            polygon.addPoint(0.0, textAndArrowHeight);
            polygon.addPoint(this.getArrowDeltaX(), textAndArrowHeight + (double)this.getArrowDeltaY());
            if (this.niceArrow) {
                polygon.addPoint(this.getArrowDeltaX() - 4, textAndArrowHeight);
            }
        }
        return polygon;
    }

    @Override
    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        double textHeight = this.getTextHeight(stringBounder);
        return new Point2D.Double(this.getPaddingX(), textHeight + this.getPaddingY());
    }

    @Override
    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        double textHeight = this.getTextHeight(stringBounder);
        double textAndArrowHeight = textHeight + this.getArrowOnlyHeight(stringBounder);
        return new Point2D.Double(this.getPaddingX(), textAndArrowHeight + this.getPaddingY());
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        double textHeight = this.getTextHeight(stringBounder);
        double textAndArrowHeight = textHeight + this.getArrowOnlyHeight(stringBounder);
        return (textHeight + textAndArrowHeight) / 2.0 + this.getPaddingX();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + this.getArrowOnlyHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    private double getArrowOnlyHeight(StringBounder stringBounder) {
        return 13.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), 45.0);
    }
}

