/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class TextTable {
    private static final DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
    private final List<TextLine> lines = new ArrayList<TextLine>();

    public void addLine(Object ... cells) {
        this.lines.add(new DataLine(cells));
    }

    public void addSeparator() {
        this.lines.add(new Separator());
    }

    private int[] getColsWidth() {
        int[] result = new int[this.getNbCols()];
        for (int c = 0; c < result.length; ++c) {
            for (TextLine line : this.lines) {
                result[c] = Math.max(result[c], line.getPreferredWidth(c));
            }
        }
        return result;
    }

    private int getNbCols() {
        int result = 0;
        for (TextLine line : this.lines) {
            result = Math.max(result, line.nbCols());
        }
        return result;
    }

    public void printMe(PrintStream ps) {
        int[] width = this.getColsWidth();
        for (TextLine line : this.lines) {
            String s2 = line.getPrinted(width);
            ps.println(s2);
        }
    }

    public int getLines() {
        return this.lines.size();
    }

    static class DataLine
    implements TextLine {
        private final Object[] cells;

        private DataLine(Object[] cells) {
            this.cells = cells;
        }

        @Override
        public int nbCols() {
            return this.cells.length;
        }

        @Override
        public int getPreferredWidth(int col) {
            if (col < this.cells.length) {
                return this.formatMe(this.cells[col], 0).length();
            }
            return 0;
        }

        @Override
        public String getPrinted(int[] width) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < width.length; ++i) {
                sb.append('|');
                Object s2 = this.cells[i];
                sb.append(' ');
                sb.append(this.formatMe(s2, width[i]));
                sb.append(' ');
            }
            sb.append('|');
            return sb.toString();
        }

        private String formatMe(Object s2, int width) {
            StringBuilder sb = new StringBuilder();
            HorizontalAlignment align = HorizontalAlignment.CENTER;
            if (s2 instanceof Long) {
                String num = String.format("%,d", s2).replaceAll("\u00a0", " ");
                sb.append(num);
                align = HorizontalAlignment.RIGHT;
            } else if (s2 instanceof Date) {
                sb.append(formatter.format(s2));
            } else if (s2 != null) {
                sb.append(s2.toString());
            }
            while (sb.length() < width) {
                if (align == HorizontalAlignment.RIGHT) {
                    sb.insert(0, " ");
                } else {
                    sb.append(" ");
                }
                if (align != HorizontalAlignment.CENTER || sb.length() >= width) continue;
                sb.insert(0, " ");
            }
            return sb.toString();
        }
    }

    static class Separator
    implements TextLine {
        Separator() {
        }

        @Override
        public int nbCols() {
            return 0;
        }

        @Override
        public int getPreferredWidth(int col) {
            return 0;
        }

        @Override
        public String getPrinted(int[] width) {
            StringBuilder sb = new StringBuilder();
            for (int w : width) {
                sb.append('+');
                for (int i = 0; i < w + 2; ++i) {
                    sb.append('-');
                }
            }
            sb.append('+');
            return sb.toString();
        }
    }

    static interface TextLine {
        public int nbCols();

        public int getPreferredWidth(int var1);

        public String getPrinted(int[] var1);
    }
}

