/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.python.PythonCode;
import org.testingisdocumenting.znai.python.PythonCodeEntry;
import org.testingisdocumenting.znai.python.PythonIncludePluginBase;
import org.testingisdocumenting.znai.python.PythonIncludeResult;
import org.testingisdocumenting.znai.python.pydoc.ParsedPythonDoc;

public class PythonDocParamsIncludePlugin
extends PythonIncludePluginBase {
    @Override
    public String id() {
        return "python-doc-params";
    }

    @Override
    public IncludePlugin create() {
        return new PythonDocParamsIncludePlugin();
    }

    @Override
    public PythonIncludeResult process(PythonCode parsed) {
        PythonCodeEntry codeEntry = this.findEntryByName(parsed, this.entryName);
        ParsedPythonDoc parsedPythonDoc = new ParsedPythonDoc(codeEntry.getDocString());
        ApiParameters apiParameters = new ApiParameters(this.entryName);
        parsedPythonDoc.getParams().forEach(pythonParam -> {
            MarkupParserResult parsedMarkdown = this.componentsRegistry.markdownParser().parse(this.fullPath, pythonParam.getPyDocText());
            apiParameters.add(pythonParam.getName(), pythonParam.getType(), parsedMarkdown.contentToListOfMaps(), parsedMarkdown.getAllText());
        });
        Map<String, Object> props = apiParameters.toMap();
        this.codeReferencesFeature.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List<DocElement> docElements = PluginResult.docElement("ApiParameters", props).getDocElements();
        return new PythonIncludeResult(docElements, codeEntry.getDocString());
    }
}

