/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python.pydoc;

import java.util.List;
import java.util.Set;
import org.testingisdocumenting.znai.python.PythonParam;
import org.testingisdocumenting.znai.python.pydoc.PythonDocPandasLikeParser;
import org.testingisdocumenting.znai.python.pydoc.PythonDocParser;
import org.testingisdocumenting.znai.python.pydoc.PythonDocParserResult;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class ParsedPythonDoc {
    private static final PythonDocParser DEFAULT = new PythonDocPandasLikeParser();
    private static final Set<PythonDocParser> paramsParsers = ServiceLoaderUtils.load(PythonDocParser.class);
    private final String pyDoc;
    private final String pyDocDescriptionOnly;
    private final List<PythonParam> params;

    public ParsedPythonDoc(String pyDoc) {
        PythonDocParser parser = this.findParser();
        PythonDocParserResult parserResult = parser.parse(pyDoc);
        this.pyDoc = pyDoc;
        this.params = parserResult.getParams();
        this.pyDocDescriptionOnly = parserResult.getDescriptionOnly();
    }

    public String getPyDoc() {
        return this.pyDoc;
    }

    public String getPyDocDescriptionOnly() {
        return this.pyDocDescriptionOnly;
    }

    public List<PythonParam> getParams() {
        return this.params;
    }

    private PythonDocParser findParser() {
        return paramsParsers.stream().filter(parser -> parser.handles(this.pyDoc)).findFirst().map(PythonDocParser::create).orElse(DEFAULT.create());
    }
}

