/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.cli;

import java.util.Objects;
import java.util.Set;
import znaishaded.io.vertx.core.cli.Option;
import znaishaded.io.vertx.core.cli.converters.Converter;

public class TypedOption<T>
extends Option {
    protected Class<T> type;
    protected boolean parsedAsList;
    protected String listSeparator = ",";
    protected Converter<T> converter;

    public TypedOption() {
    }

    public TypedOption(TypedOption<T> option) {
        super(option);
        this.type = option.getType();
        this.converter = option.getConverter();
        this.parsedAsList = option.isParsedAsList();
        this.listSeparator = option.getListSeparator();
    }

    @Override
    public TypedOption<T> setMultiValued(boolean acceptMultipleValues) {
        super.setMultiValued(acceptMultipleValues);
        return this;
    }

    @Override
    public TypedOption<T> setSingleValued(boolean acceptSingleValue) {
        super.setSingleValued(acceptSingleValue);
        return this;
    }

    @Override
    public TypedOption<T> setArgName(String argName) {
        super.setArgName(argName);
        return this;
    }

    @Override
    public TypedOption<T> setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        return this;
    }

    @Override
    public TypedOption<T> setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public TypedOption<T> setFlag(boolean flag) {
        super.setFlag(flag);
        return this;
    }

    @Override
    public TypedOption<T> setHidden(boolean hidden) {
        super.setHidden(hidden);
        return this;
    }

    @Override
    public TypedOption<T> setLongName(String longName) {
        super.setLongName(longName);
        return this;
    }

    @Override
    public TypedOption<T> setRequired(boolean required) {
        super.setRequired(required);
        return this;
    }

    @Override
    public TypedOption<T> setShortName(String shortName) {
        super.setShortName(shortName);
        return this;
    }

    public Class<T> getType() {
        return this.type;
    }

    public TypedOption<T> setType(Class<T> type) {
        this.type = type;
        if (type != null && this.getChoices().isEmpty() && type.isEnum()) {
            this.setChoicesFromEnumType();
        }
        return this;
    }

    public boolean isParsedAsList() {
        return this.parsedAsList;
    }

    public TypedOption<T> setParsedAsList(boolean isList) {
        this.parsedAsList = isList;
        return this;
    }

    public String getListSeparator() {
        return this.listSeparator;
    }

    public TypedOption<T> setListSeparator(String listSeparator) {
        Objects.requireNonNull(listSeparator);
        this.parsedAsList = true;
        this.listSeparator = listSeparator;
        return this;
    }

    public Converter<T> getConverter() {
        return this.converter;
    }

    public TypedOption<T> setConverter(Converter<T> converter) {
        this.converter = converter;
        return this;
    }

    @Override
    public void ensureValidity() {
        super.ensureValidity();
        if (this.type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
    }

    @Override
    public TypedOption<T> setChoices(Set<String> choices) {
        super.setChoices(choices);
        return this;
    }

    @Override
    public TypedOption<T> addChoice(String choice) {
        super.addChoice(choice);
        return this;
    }

    private void setChoicesFromEnumType() {
        T[] constants;
        for (T c : constants = this.type.getEnumConstants()) {
            this.addChoice(c.toString());
        }
    }
}

